/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertAutomaticManifestProcessor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConvertAutomaticManifestsWizardSettingsPage
extends UserInputWizardPage {
    private static final String SECTION_NAME = "ConvertAutomaticManifestPage";
    private static final String KEY_USE_PROJECT_ROOT = "use_project_root";
    private static final String KEY_KEEP_REQUIRE_BUNDLE = "keep_require_bundle";
    private static final String KEY_KEEP_IMPORT_PACKAGE = "keep_import_package";
    private static final String KEY_KEEP_EXPORT_PACKAGE = "keep_export_package";
    private static final String KEY_KEEP_REQUIREDEXECUTIONENVIRONMENT = "keep_requiredexecutionenvironment_package";
    private ConvertAutomaticManifestProcessor processor;

    public ConvertAutomaticManifestsWizardSettingsPage(ConvertAutomaticManifestProcessor processor) {
        super(PDEUIMessages.ConvertAutomaticManifestWizardPage_title);
        this.processor = processor;
        this.setTitle(PDEUIMessages.ConvertAutomaticManifestWizardPage_title);
        this.setDescription(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createGenerateOption(composite);
        this.createRequireBundleOption(composite);
        this.createImportPackageOption(composite);
        this.createRequiredExecutionEnvironmentOption(composite);
        this.createExportPackageOption(composite);
    }

    private void createExportPackageOption(Composite parent) {
        new Label(parent, 0).setText("Export-Package");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button optionAnnotations = new Button(composite, 16);
        optionAnnotations.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_convert_to_annotations);
        Button optionKeep = new Button(composite, 16);
        optionKeep.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_keep);
        IDialogSettings settings = this.getSettings();
        if (settings.getBoolean(KEY_KEEP_EXPORT_PACKAGE)) {
            optionKeep.setSelection(true);
            this.processor.setKeepExportPackage(true);
        } else {
            optionAnnotations.setSelection(true);
        }
        optionAnnotations.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionAnnotations.getSelection()) {
                this.getSettings().put(KEY_KEEP_EXPORT_PACKAGE, false);
                this.processor.setKeepExportPackage(false);
            }
        }));
        optionKeep.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionKeep.getSelection()) {
                this.getSettings().put(KEY_KEEP_EXPORT_PACKAGE, true);
                this.processor.setKeepExportPackage(true);
            }
        }));
    }

    private void createRequiredExecutionEnvironmentOption(Composite parent) {
        new Label(parent, 0).setText("Bundle-RequiredExecutionEnvironment");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button optionInstructions = new Button(composite, 16);
        optionInstructions.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_to_instructions);
        Button optionKeep = new Button(composite, 16);
        optionKeep.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_keep);
        IDialogSettings settings = this.getSettings();
        if (settings.getBoolean(KEY_KEEP_REQUIREDEXECUTIONENVIRONMENT)) {
            optionKeep.setSelection(true);
            this.processor.setKeepRequiredExecutionEnvironment(true);
        } else {
            optionInstructions.setSelection(true);
        }
        optionInstructions.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionInstructions.getSelection()) {
                this.getSettings().put(KEY_KEEP_REQUIREDEXECUTIONENVIRONMENT, false);
                this.processor.setKeepRequiredExecutionEnvironment(false);
            }
        }));
        optionKeep.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionKeep.getSelection()) {
                this.getSettings().put(KEY_KEEP_REQUIREDEXECUTIONENVIRONMENT, true);
                this.processor.setKeepRequiredExecutionEnvironment(true);
            }
        }));
    }

    private void createImportPackageOption(Composite parent) {
        new Label(parent, 0).setText("Import-Package");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button optionDiscard = new Button(composite, 16);
        optionDiscard.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_discard);
        Button optionKeep = new Button(composite, 16);
        optionKeep.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_keep);
        IDialogSettings settings = this.getSettings();
        if (settings.getBoolean(KEY_KEEP_IMPORT_PACKAGE)) {
            optionKeep.setSelection(true);
            this.processor.setKeepImportPackage(true);
        } else {
            optionDiscard.setSelection(true);
        }
        optionDiscard.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionDiscard.getSelection()) {
                this.getSettings().put(KEY_KEEP_IMPORT_PACKAGE, false);
                this.processor.setKeepImportPackage(false);
            }
        }));
        optionKeep.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionKeep.getSelection()) {
                this.getSettings().put(KEY_KEEP_IMPORT_PACKAGE, true);
                this.processor.setKeepImportPackage(true);
            }
        }));
    }

    private void createRequireBundleOption(Composite parent) {
        new Label(parent, 0).setText("Require-Bundle");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button optionDiscard = new Button(composite, 16);
        optionDiscard.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_discard);
        Button optionKeep = new Button(composite, 16);
        optionKeep.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_keep);
        IDialogSettings settings = this.getSettings();
        if (settings.getBoolean(KEY_KEEP_REQUIRE_BUNDLE)) {
            optionKeep.setSelection(true);
            this.processor.setKeepRequireBundle(true);
        } else {
            optionDiscard.setSelection(true);
        }
        optionDiscard.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionDiscard.getSelection()) {
                this.getSettings().put(KEY_KEEP_REQUIRE_BUNDLE, false);
                this.processor.setKeepRequireBundle(false);
            }
        }));
        optionKeep.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionKeep.getSelection()) {
                this.getSettings().put(KEY_KEEP_REQUIRE_BUNDLE, true);
                this.processor.setKeepRequireBundle(true);
            }
        }));
    }

    private void createGenerateOption(Composite parent) {
        new Label(parent, 0).setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_manifest);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button optionOutput = new Button(composite, 16);
        optionOutput.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_manifest_at_output);
        Button optionRoot = new Button(composite, 16);
        optionRoot.setText(PDEUIMessages.ConvertAutomaticManifestsWizardSettingsPage_manifest_at_root);
        IDialogSettings settings = this.getSettings();
        if (settings.getBoolean(KEY_USE_PROJECT_ROOT)) {
            optionRoot.setSelection(true);
            this.processor.setUseProjectRoot(true);
        } else {
            optionOutput.setSelection(true);
            this.processor.setUseProjectRoot(false);
        }
        optionOutput.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionOutput.getSelection()) {
                this.getSettings().put(KEY_USE_PROJECT_ROOT, false);
                this.processor.setUseProjectRoot(false);
            }
        }));
        optionRoot.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (optionRoot.getSelection()) {
                this.getSettings().put(KEY_USE_PROJECT_ROOT, true);
                this.processor.setUseProjectRoot(true);
            }
        }));
    }

    private IDialogSettings getSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(SECTION_NAME);
        if (section == null) {
            return settings.addNewSection(SECTION_NAME);
        }
        return section;
    }
}

