/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Selection;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

public class CompoundSelectionImpl
extends SelectionImpl
implements CompoundSelection {
    protected ArrayList<Selection<?>> subSelections = new ArrayList();
    protected ArrayList<String> duplicateAliasNames;

    public CompoundSelectionImpl(Class javaType, Selection[] subSelections) {
        this(javaType, subSelections, false);
    }

    public CompoundSelectionImpl(Class javaType, Selection[] subSelections, boolean validate) {
        super(javaType, null);
        TreeMap<String, Selection> tempMap = new TreeMap<String, Selection>();
        Selection[] selectionArray = subSelections;
        int n = subSelections.length;
        int n2 = 0;
        while (n2 < n) {
            Selection sel = selectionArray[n2];
            if (validate && ((SelectionImpl)sel).isCompoundSelection() && !((SelectionImpl)sel).isConstructor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_criteriaapi_illegal_tuple_or_array_value", (Object[])new Object[]{sel}));
            }
            String alias = sel.getAlias();
            if (alias != null) {
                if (tempMap.containsKey(alias)) {
                    if (this.duplicateAliasNames == null) {
                        this.duplicateAliasNames = new ArrayList();
                    }
                    this.duplicateAliasNames.add(alias);
                } else {
                    tempMap.put(alias, sel);
                }
            }
            this.subSelections.add(sel);
            ++n2;
        }
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        return this.subSelections;
    }

    protected List<String> getDuplicateAliasNames() {
        return this.duplicateAliasNames;
    }

    @Override
    public void findRootAndParameters(CommonAbstractCriteriaImpl criteriaQuery) {
        for (Selection<?> selection : this.getCompoundSelectionItems()) {
            ((InternalSelection)selection).findRootAndParameters(criteriaQuery);
        }
    }
}

