/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.php.composer.api.entities.JsonValue;

public class Entity {
    protected transient PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue instanceof JsonValue) {
            oldValue = this.getRawObject((JsonValue)oldValue);
        }
        if (newValue instanceof JsonValue) {
            newValue = this.getRawObject((JsonValue)newValue);
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private Object getRawObject(JsonValue value) {
        if (value.isArray()) {
            return value.getAsArray();
        }
        if (value.isObject()) {
            return value.getAsObject();
        }
        if (value.isNumber()) {
            return value.getAsNumber();
        }
        if (value.isBoolean()) {
            return value.getAsBoolean();
        }
        return value.getAsString();
    }
}

