/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchPatternProcessor;

public class PHPSearchPatternProcessor
extends SearchPatternProcessor {
    private static final String TYPE_DELIMITER = "\\";
    private static final String OBJ_CALL_DELIMITER = "->";
    private static final String STATIC_CALL_DELIMITER = "::";

    public char[] extractDeclaringTypeQualification(String pattern) {
        int pos = pattern.indexOf(OBJ_CALL_DELIMITER);
        int pos2 = pattern.indexOf(STATIC_CALL_DELIMITER);
        int n = pos == -1 ? pos2 : (pos = pos2 == -1 ? pos : Math.min(pos, pos2));
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeQualification(type);
        }
        return null;
    }

    public char[] extractDeclaringTypeSimpleName(String pattern) {
        int pos = pattern.indexOf(OBJ_CALL_DELIMITER);
        int pos2 = pattern.indexOf(STATIC_CALL_DELIMITER);
        int n = pos == -1 ? pos2 : (pos = pos2 == -1 ? pos : Math.min(pos, pos2));
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeChars(type).toCharArray();
        }
        return null;
    }

    public char[] extractSelector(String pattern) {
        int begin;
        int pos = pattern.indexOf(OBJ_CALL_DELIMITER);
        int pos2 = pattern.indexOf(STATIC_CALL_DELIMITER);
        int n = pos == -1 ? pos2 : (pos = pos2 == -1 ? pos : Math.min(pos, pos2));
        if (pos != -1 && (begin = pos + 2) < pattern.length()) {
            char[] result = new char[pattern.length() - begin];
            pattern.getChars(begin, pattern.length(), result, 0);
            return result;
        }
        return pattern.toCharArray();
    }

    private String extractPHPTypeChars(String pattern) {
        int begin;
        int pos = pattern.lastIndexOf(TYPE_DELIMITER);
        if (pos != -1 && (begin = pos + TYPE_DELIMITER.length()) < pattern.length()) {
            return pattern.substring(begin);
        }
        return pattern;
    }

    private String extractPHPTypeQualification(String pattern) {
        int pos = pattern.lastIndexOf(TYPE_DELIMITER);
        if (pos != -1) {
            char[] result = new char[pos];
            pattern.getChars(0, pos, result, 0);
            return new String(CharOperation.replace((char[])result, (char[])TYPE_DELIMITER.toCharArray(), (char[])new char[]{'$'}));
        }
        return null;
    }

    public String getDelimiterReplacementString() {
        return TYPE_DELIMITER;
    }

    public ISearchPatternProcessor.ITypePattern parseType(String patternString) {
        return new SearchPatternProcessor.TypePatten(this.extractPHPTypeQualification(patternString), this.extractPHPTypeChars(patternString));
    }
}

