/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.IInstanceContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.goals.FactoryMethodMethodReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class MethodCallTypeEvaluator
extends GoalEvaluator {
    private static final int STATE_INIT = 0;
    private static final int STATE_WAITING_RECEIVER = 1;
    private static final int STATE_GOT_RECEIVER = 2;
    private static final int STATE_WAITING_FACTORYMETHOD = 3;
    private static final int STATE_WAITING_METHOD_PHPDOC = 4;
    private static final int STATE_WAITING_METHOD = 5;
    private int state = 0;
    private IEvaluatedType receiverType;
    private IEvaluatedType result;
    private PHPVersion phpVersion;
    private boolean phpVersionResolved = false;

    public MethodCallTypeEvaluator(ExpressionTypeGoal goal) {
        super((IGoal)goal);
    }

    private IGoal produceNextSubgoal(IGoal previousGoal, IEvaluatedType previousResult, GoalState goalState) {
        IContext context;
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        CallExpression expression = (CallExpression)typedGoal.getExpression();
        if (this.state == 0) {
            ASTNode receiver = expression.getReceiver();
            if (receiver == null) {
                this.state = 2;
            } else {
                this.state = 1;
                return new ExpressionTypeGoal(this.goal.getContext(), receiver);
            }
        }
        if (this.state == 1) {
            this.receiverType = previousResult;
            previousResult = null;
            if (this.receiverType == null) {
                return null;
            }
            this.state = 2;
        }
        if ((this.state == 3 || this.state == 4) && goalState != GoalState.PRUNED && previousResult != null && previousResult != UnknownType.INSTANCE) {
            this.result = previousResult;
            previousResult = null;
            if (!PHPTypeInferenceUtils.isGenericSimple(this.result)) {
                return null;
            }
        }
        if (this.state == 2) {
            this.state = 3;
            context = typedGoal.getContext();
            return new FactoryMethodMethodReturnTypeGoal(context, this.receiverType, expression.getName(), this.getFunctionCallArgs(context, expression), expression.sourceStart());
        }
        if (this.state == 3) {
            this.state = 4;
            context = typedGoal.getContext();
            return new PHPDocMethodReturnTypeGoal(context, this.receiverType, expression.getName(), this.getFunctionCallArgs(context, expression), expression.sourceStart());
        }
        if (this.state == 4) {
            if (goalState != GoalState.PRUNED && previousResult != null && previousResult != UnknownType.INSTANCE) {
                this.result = previousResult;
                previousResult = null;
                if (!PHPTypeInferenceUtils.isGenericSimple(this.result)) {
                    return null;
                }
            }
            this.state = 5;
            context = typedGoal.getContext();
            return new MethodElementReturnTypeGoal(context, this.receiverType, expression.getName(), this.getFunctionCallArgs(context, expression), expression.sourceStart());
        }
        if (this.state == 5 && goalState != GoalState.PRUNED && previousResult != null && previousResult != UnknownType.INSTANCE) {
            if (this.result != null) {
                this.result = PHPTypeInferenceUtils.combineTypes(Arrays.asList(this.result, previousResult));
            } else {
                this.result = previousResult;
                previousResult = null;
            }
        }
        return null;
    }

    @Nullable
    private String[] getFunctionCallArgs(@Nullable IContext context, @NonNull CallExpression callExpression) {
        CallArgumentsList args = callExpression.getArgs();
        String[] argNames = null;
        if (args != null && args.getChilds() != null) {
            List childs = args.getChilds();
            int i = 0;
            argNames = new String[childs.size()];
            for (ASTNode o : childs) {
                if (o instanceof Scalar) {
                    Scalar arg = (Scalar)o;
                    argNames[i] = ASTUtils.stripQuotes(arg.getValue());
                } else if (o instanceof StaticConstantAccess) {
                    argNames[i] = this.getFunctionCallArg(context, (StaticConstantAccess)o);
                }
                ++i;
            }
        }
        return argNames;
    }

    @Nullable
    private String getFunctionCallArg(@Nullable IContext context, @NonNull StaticConstantAccess argument) {
        if (!"class".equalsIgnoreCase(argument.getConstant().getName())) {
            return null;
        }
        PHPVersion phpVersion = this.getPHPVersion();
        if (phpVersion == null || phpVersion.isLessThan(PHPVersion.PHP5_5)) {
            return null;
        }
        if (!(context instanceof ISourceModuleContext)) {
            return null;
        }
        ISourceModule sourceModule = ((ISourceModuleContext)context).getSourceModule();
        if (sourceModule == null) {
            return null;
        }
        Expression dispatcher = argument.getDispatcher();
        if (!(dispatcher instanceof FullyQualifiedReference)) {
            return null;
        }
        String localClassName = ((FullyQualifiedReference)dispatcher).getFullyQualifiedName();
        if (localClassName.equalsIgnoreCase("self") || localClassName.equalsIgnoreCase("static")) {
            if (!(context instanceof IInstanceContext)) {
                return null;
            }
            IEvaluatedType currentClass = ((IInstanceContext)context).getInstanceType();
            if (!(currentClass instanceof PHPClassType)) {
                return null;
            }
            String fullyQualifiedName = currentClass.getTypeName();
            return fullyQualifiedName.charAt(0) == '\\' ? fullyQualifiedName.substring(1) : fullyQualifiedName;
        }
        return PHPModelUtils.getFullName(localClassName, sourceModule, argument.sourceStart());
    }

    @Nullable
    private PHPVersion getPHPVersion() {
        ISourceModule sourceModule;
        if (this.phpVersionResolved) {
            return this.phpVersion;
        }
        IContext context = this.goal.getContext();
        if (context instanceof ISourceModuleContext && (sourceModule = ((ISourceModuleContext)context).getSourceModule()) != null) {
            this.phpVersion = ProjectOptions.getPHPVersion(sourceModule.getScriptProject().getProject());
        }
        this.phpVersionResolved = true;
        return this.phpVersion;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] init() {
        IGoal goal = this.produceNextSubgoal(null, null, null);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IGoal goal = this.produceNextSubgoal(subgoal, (IEvaluatedType)result, state);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }
}

