/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.core.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.rdt.sync.core.services.SynchronizeServiceDescriptor;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeServiceDescriptor;

public class SynchronizeServiceRegistry {
    public static final String SYNCHRONIZE_SERVICE_EXTENSION = "synchronizeService";
    public static final String ATTR_ID = "id";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_NAME = "name";
    private static Map<String, ISynchronizeServiceDescriptor> fSyncServices;

    public static ISynchronizeServiceDescriptor[] getSynchronizeServiceDescriptors() {
        SynchronizeServiceRegistry.loadServices();
        return fSyncServices.values().toArray(new ISynchronizeServiceDescriptor[0]);
    }

    public static ISynchronizeServiceDescriptor getSynchronizeServiceDescriptor(String id) {
        SynchronizeServiceRegistry.loadServices();
        return fSyncServices.get(id);
    }

    private static void loadServices() {
        if (fSyncServices == null) {
            fSyncServices = new HashMap<String, ISynchronizeServiceDescriptor>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ptp.rdt.sync.core", SYNCHRONIZE_SERVICE_EXTENSION);
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configElement = iConfigurationElementArray[n4];
                        String id = configElement.getAttribute(ATTR_ID);
                        if (id != null) {
                            SynchronizeServiceDescriptor desc = new SynchronizeServiceDescriptor(configElement);
                            fSyncServices.put(id, desc);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }
}

