/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ConnectivityChecker {
    public static final @NonNull TracingOption CONNECTIVITY = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/connectivity");
    public static final @NonNull TracingOption CONNECTIVITY_CLASSDATUMS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/connectivity/classdatums");
    public static final @NonNull TracingOption CONNECTIVITY_CONNECTIONS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/connectivity/connections");
    public static final @NonNull TracingOption CONNECTIVITY_EDGES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/connectivity/edges");
    public static final @NonNull TracingOption CONNECTIVITY_NODES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/connectivity/nodes");
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ScheduleModel scheduleModel;
    private final @NonNull Map<@NonNull String, @NonNull ClassDatum> name2classDatum = new HashMap<String, ClassDatum>();
    private final @NonNull Map<@NonNull String, @NonNull Connection> name2connection = new HashMap<String, Connection>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull ClassDatum>> classDatum2subClassDatums = new HashMap<ClassDatum, Set<ClassDatum>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull Set<@NonNull ClassDatum>> classDatum2superClassDatums = new HashMap<ClassDatum, Set<ClassDatum>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Connection>> producer2connections = new HashMap<ClassDatum, List<Connection>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Connection>> consumer2connections = new HashMap<ClassDatum, List<Connection>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> producer2nodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Node>> consumer2nodes = new HashMap<ClassDatum, List<Node>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Edge>> producer2edges = new HashMap<ClassDatum, List<Edge>>();
    private final @NonNull Map<@NonNull ClassDatum, @NonNull List<@NonNull Edge>> consumer2edges = new HashMap<ClassDatum, List<Edge>>();

    public static void checkConnectivity(@NonNull ScheduleManager scheduleManager) throws CompilerChainException {
        String connectivityProblems;
        ConnectivityChecker connectivityChecker = new ConnectivityChecker(scheduleManager);
        connectivityChecker.analyze();
        if (CONNECTIVITY_CLASSDATUMS.isActive()) {
            CONNECTIVITY_CLASSDATUMS.println("SubClassDatums" + connectivityChecker.showSubClassDatums(new StringBuilder()));
            CONNECTIVITY_CLASSDATUMS.println("SuperClassDatums" + connectivityChecker.showSuperClassDatums(new StringBuilder()));
        }
        if (CONNECTIVITY_CONNECTIONS.isActive()) {
            CONNECTIVITY_CONNECTIONS.println("Connection connectivity" + connectivityChecker.showConnectionConnectivity(new StringBuilder()));
        }
        if (CONNECTIVITY_NODES.isActive()) {
            CONNECTIVITY_NODES.println("Node connectivity" + connectivityChecker.showNodeConnectivity(new StringBuilder()));
        }
        if (CONNECTIVITY_EDGES.isActive()) {
            CONNECTIVITY_EDGES.println("Edge connectivity" + connectivityChecker.showEdgeConnectivity(new StringBuilder()));
        }
        if ((connectivityProblems = connectivityChecker.checkConnectivity("\t")) != null) {
            throw new CompilerChainException("Schedule has connectivity problems\n" + connectivityProblems, new Object[0]);
        }
    }

    public ConnectivityChecker(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
        this.scheduleModel = scheduleManager.getScheduleModel();
    }

    protected @NonNull ClassDatum addClassDatum(@NonNull Node node) {
        ClassDatum classDatum = this.getNormalizedClassDatum(node);
        String name = QVTscheduleUtil.getName((Nameable)classDatum);
        ClassDatum oldClassDatum = this.name2classDatum.put(name, classDatum);
        assert (oldClassDatum == null || oldClassDatum == classDatum);
        return classDatum;
    }

    public void analyze() {
        for (ClassDatum classDatum : QVTscheduleUtil.getOwnedClassDatums((ScheduleModel)this.scheduleModel)) {
            this.analyzeClassDatums(classDatum);
        }
        for (RootRegion rootRegion : QVTscheduleUtil.getOwnedRootRegions((ScheduleModel)this.scheduleModel)) {
            for (Connection connection : QVTscheduleUtil.getOwnedConnections((RootRegion)rootRegion)) {
                this.analyzeConnection(connection);
            }
            this.analyzeRegion((Region)QVTscheduleUtil.getOwnedLoadingRegion((RootRegion)rootRegion));
            for (Region region : QVTscheduleUtil.getActiveRegions((RootRegion)rootRegion)) {
                this.analyzeRegion(region);
            }
        }
    }

    private @NonNull Set<@NonNull ClassDatum> analyzeClassDatums(@NonNull ClassDatum classDatum) {
        Set<@NonNull ClassDatum> superClassDatums = this.classDatum2superClassDatums.get(classDatum);
        if (superClassDatums == null) {
            superClassDatums = new HashSet<ClassDatum>();
            this.classDatum2superClassDatums.put(classDatum, superClassDatums);
            superClassDatums.add(classDatum);
            for (ClassDatum superClassDatum : this.scheduleManager.getSuperClassDatums(classDatum)) {
                for (ClassDatum transitiveSuperClassDatum : this.analyzeClassDatums(superClassDatum)) {
                    superClassDatums.add(transitiveSuperClassDatum);
                    Set<@NonNull ClassDatum> subClassDatums = this.classDatum2subClassDatums.get(transitiveSuperClassDatum);
                    if (subClassDatums == null) {
                        subClassDatums = new HashSet<ClassDatum>();
                        this.classDatum2subClassDatums.put(transitiveSuperClassDatum, subClassDatums);
                        subClassDatums.add(transitiveSuperClassDatum);
                    }
                    subClassDatums.add(classDatum);
                }
            }
        }
        return superClassDatums;
    }

    protected void analyzeConnection(@NonNull Connection connection) {
        List<Connection> connections;
        ClassDatum classDatum;
        Connection oldConnection = this.name2connection.put(QVTscheduleUtil.getName((Nameable)connection), connection);
        assert (oldConnection == null);
        for (Node sourceNode : connection.getSourceNodes()) {
            classDatum = this.addClassDatum(sourceNode);
            connections = this.producer2connections.get(classDatum);
            if (connections == null) {
                connections = new ArrayList<Connection>();
                this.producer2connections.put(classDatum, connections);
            }
            connections.add(connection);
        }
        for (Node targetNode : connection.getTargetNodes()) {
            classDatum = this.addClassDatum(targetNode);
            connections = this.consumer2connections.get(classDatum);
            if (connections == null) {
                connections = new ArrayList<Connection>();
                this.consumer2connections.put(classDatum, connections);
            }
            connections.add(connection);
        }
    }

    protected void analyzeRegion(@NonNull Region region) {
        ClassDatum classDatum;
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            List<Node> nodes;
            if (node.isNew()) {
                classDatum = this.addClassDatum(node);
                nodes = this.producer2nodes.get(classDatum);
                if (nodes == null) {
                    nodes = new ArrayList<Node>();
                    this.producer2nodes.put(classDatum, nodes);
                }
                assert (!nodes.contains(node));
                nodes.add(node);
            }
            if (!node.isChecked()) continue;
            classDatum = this.addClassDatum(node);
            nodes = this.consumer2nodes.get(classDatum);
            if (nodes == null) {
                nodes = new ArrayList<Node>();
                this.consumer2nodes.put(classDatum, nodes);
            }
            assert (!nodes.contains(node));
            nodes.add(node);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
            List<Edge> edges;
            if (edge.isRealized()) {
                classDatum = this.addClassDatum(QVTscheduleUtil.getSourceNode((Edge)edge));
                edges = this.producer2edges.get(classDatum);
                if (edges == null) {
                    edges = new ArrayList<Edge>();
                    this.producer2edges.put(classDatum, edges);
                }
                assert (!edges.contains(edge));
                edges.add(edge);
            }
            if (!edge.isPredicated()) continue;
            classDatum = this.addClassDatum(QVTscheduleUtil.getSourceNode((Edge)edge));
            edges = this.consumer2edges.get(classDatum);
            if (edges == null) {
                edges = new ArrayList<Edge>();
                this.consumer2edges.put(classDatum, edges);
            }
            assert (!edges.contains(edge));
            edges.add(edge);
        }
    }

    public @Nullable String checkConnectivity(@Nullable String linePrefix) {
        StringBuilder s = null;
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            int consumers;
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)classDatum);
            if (!domainUsage.isMiddle() && !this.scheduleManager.isOutput(domainUsage)) continue;
            int subProducers = this.getSubProducers(classDatum).size();
            List<@NonNull Node> producingNodes = this.producer2nodes.get(classDatum);
            List<@NonNull Node> consumingNodes = this.consumer2nodes.get(classDatum);
            int producers = producingNodes != null ? producingNodes.size() : 0;
            int n = consumers = consumingNodes != null ? consumingNodes.size() : 0;
            if (consumers <= 0 || producers != 0 || subProducers != 0) continue;
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append("\n");
            }
            if (linePrefix != null) {
                s.append(linePrefix);
            }
            s.append(name);
            s.append(" is consumed but not produced");
        }
        return s != null ? s.toString() : null;
    }

    private @NonNull ClassDatum getNormalizedClassDatum(@NonNull Node node) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)node);
        Class primaryClass = ((CompleteClass)classDatum.getCompleteClasses().iterator().next()).getPrimaryClass();
        if (primaryClass instanceof CollectionType) {
            primaryClass = (Class)PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
            classDatum = this.scheduleManager.getClassDatum(QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum), (Type)primaryClass);
        }
        throw new UnsupportedOperationException();
    }

    private @NonNull Set<@NonNull Node> getSubConsumers(@NonNull ClassDatum classDatum) {
        HashSet<@NonNull Node> subConsumers = new HashSet<Node>();
        Set<@NonNull ClassDatum> subClassDatums = this.classDatum2subClassDatums.get(classDatum);
        if (subClassDatums != null) {
            for (ClassDatum subClassDatum : subClassDatums) {
                List<Node> subConsumingNodes;
                if (subClassDatum == classDatum || (subConsumingNodes = this.consumer2nodes.get(subClassDatum)) == null) continue;
                subConsumers.addAll(subConsumingNodes);
            }
        }
        return subConsumers;
    }

    private @NonNull Set<@NonNull Node> getSubProducers(@NonNull ClassDatum classDatum) {
        HashSet<@NonNull Node> subProducers = new HashSet<Node>();
        Set<@NonNull ClassDatum> subClassDatums = this.classDatum2subClassDatums.get(classDatum);
        if (subClassDatums != null) {
            for (ClassDatum subClassDatum : subClassDatums) {
                List<Node> subProducingNodes;
                if (subClassDatum == classDatum || (subProducingNodes = this.producer2nodes.get(subClassDatum)) == null) continue;
                subProducers.addAll(subProducingNodes);
            }
        }
        return subProducers;
    }

    private @NonNull Set<@NonNull Node> getSuperConsumers(@NonNull ClassDatum classDatum) {
        HashSet<@NonNull Node> superConsumers = new HashSet<Node>();
        Set<@NonNull ClassDatum> superClassDatums = this.classDatum2superClassDatums.get(classDatum);
        if (superClassDatums != null) {
            for (ClassDatum superClassDatum : superClassDatums) {
                List<Node> superConsumingNodes;
                if (superClassDatum == classDatum || (superConsumingNodes = this.consumer2nodes.get(superClassDatum)) == null) continue;
                superConsumers.addAll(superConsumingNodes);
            }
        }
        return superConsumers;
    }

    private @NonNull Set<@NonNull Node> getSuperProducers(@NonNull ClassDatum classDatum) {
        HashSet<@NonNull Node> superProducers = new HashSet<Node>();
        Set<@NonNull ClassDatum> superClassDatums = this.classDatum2superClassDatums.get(classDatum);
        if (superClassDatums != null) {
            for (ClassDatum superClassDatum : superClassDatums) {
                List<Node> superProducingNodes;
                if (superClassDatum == classDatum || (superProducingNodes = this.producer2nodes.get(superClassDatum)) == null) continue;
                superProducers.addAll(superProducingNodes);
            }
        }
        return superProducers;
    }

    public @NonNull StringBuilder showConnectionConnectivity(@NonNull StringBuilder s) {
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            int consumers;
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            List<@NonNull Connection> producingConnections = this.producer2connections.get(classDatum);
            List<@NonNull Connection> consumingConnections = this.consumer2connections.get(classDatum);
            int producers = producingConnections != null ? producingConnections.size() : 0;
            int n = consumers = consumingConnections != null ? consumingConnections.size() : 0;
            if (consumers <= 0 && producers <= 0) continue;
            s.append("\n\t");
            s.append(producers);
            s.append("=>");
            s.append(consumers);
            s.append(" ");
            s.append(name);
        }
        return s;
    }

    public @NonNull StringBuilder showEdgeConnectivity(@NonNull StringBuilder s) {
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            int consumers;
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            int superProducers = 0;
            int superConsumers = 0;
            Set<@NonNull ClassDatum> superClassDatums = this.classDatum2superClassDatums.get(classDatum);
            if (superClassDatums != null) {
                for (ClassDatum superClassDatum : superClassDatums) {
                    if (superClassDatum == classDatum) continue;
                    List<@NonNull Edge> superProducingEdges = this.producer2edges.get(superClassDatum);
                    List<@NonNull Edge> superConsumingEdges = this.consumer2edges.get(superClassDatum);
                    if (superProducingEdges != null) {
                        superProducers += superProducingEdges.size();
                    }
                    if (superConsumingEdges == null) continue;
                    superConsumers += superConsumingEdges.size();
                }
            }
            int subProducers = 0;
            int subConsumers = 0;
            Set<@NonNull ClassDatum> subClassDatums = this.classDatum2subClassDatums.get(classDatum);
            if (subClassDatums != null) {
                for (ClassDatum subClassDatum : subClassDatums) {
                    if (subClassDatum == classDatum) continue;
                    List<@NonNull Edge> subProducingEdges = this.producer2edges.get(subClassDatum);
                    List<@NonNull Edge> subConsumingEdges = this.consumer2edges.get(subClassDatum);
                    if (subProducingEdges != null) {
                        subProducers += subProducingEdges.size();
                    }
                    if (subConsumingEdges == null) continue;
                    subConsumers += subConsumingEdges.size();
                }
            }
            List<@NonNull Edge> producingEdges = this.producer2edges.get(classDatum);
            List<@NonNull Edge> consumingEdges = this.consumer2edges.get(classDatum);
            int producers = producingEdges != null ? producingEdges.size() : 0;
            int n = consumers = consumingEdges != null ? consumingEdges.size() : 0;
            if (consumers <= 0 && producers <= 0 && subConsumers <= 0 && subProducers <= 0 && superConsumers <= 0 && superProducers <= 0) continue;
            s.append("\n\t(");
            s.append(superProducers);
            s.append("),");
            s.append(producers);
            s.append(",(");
            s.append(subProducers);
            s.append(")=>(");
            s.append(superConsumers);
            s.append("),");
            s.append(consumers);
            s.append(",(");
            s.append(subConsumers);
            s.append(") ");
            s.append(name);
        }
        return s;
    }

    public @NonNull StringBuilder showNodeConnectivity(@NonNull StringBuilder s) {
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            int consumers;
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            int superProducers = this.getSuperProducers(classDatum).size();
            int superConsumers = this.getSuperConsumers(classDatum).size();
            int subProducers = this.getSubProducers(classDatum).size();
            int subConsumers = this.getSubConsumers(classDatum).size();
            List<@NonNull Node> producingNodes = this.producer2nodes.get(classDatum);
            List<@NonNull Node> consumingNodes = this.consumer2nodes.get(classDatum);
            int producers = producingNodes != null ? producingNodes.size() : 0;
            int n = consumers = consumingNodes != null ? consumingNodes.size() : 0;
            if (consumers <= 0 && producers <= 0 && subConsumers <= 0 && subProducers <= 0 && superConsumers <= 0 && superProducers <= 0) continue;
            s.append("\n\t(");
            s.append(superProducers);
            s.append("),");
            s.append(producers);
            s.append(",(");
            s.append(subProducers);
            s.append(")=>(");
            s.append(superConsumers);
            s.append("),");
            s.append(consumers);
            s.append(",(");
            s.append(subConsumers);
            s.append(") ");
            s.append(name);
        }
        return s;
    }

    public @NonNull StringBuilder showSubClassDatums(@NonNull StringBuilder s) {
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            Set<@NonNull ClassDatum> subClassDatums = this.classDatum2subClassDatums.get(classDatum);
            if (subClassDatums == null || subClassDatums.size() <= 1) continue;
            s.append("\n\t");
            s.append(name);
            ArrayList<@NonNull String> names2 = new ArrayList<String>();
            for (ClassDatum subClassDatum : subClassDatums) {
                if (subClassDatum == classDatum) continue;
                names2.add(QVTscheduleUtil.getName((Nameable)subClassDatum));
            }
            Collections.sort(names2);
            for (String name2 : names2) {
                s.append("\n\t\t");
                s.append(name2);
            }
        }
        return s;
    }

    public @NonNull StringBuilder showSuperClassDatums(@NonNull StringBuilder s) {
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2classDatum.keySet());
        Collections.sort(names);
        for (String name : names) {
            ClassDatum classDatum = this.name2classDatum.get(name);
            assert (classDatum != null);
            Set<@NonNull ClassDatum> superClassDatums = this.classDatum2superClassDatums.get(classDatum);
            if (superClassDatums == null || superClassDatums.size() <= 1) continue;
            s.append("\n\t");
            s.append(name);
            ArrayList<@NonNull String> names2 = new ArrayList<String>();
            for (ClassDatum superClassDatum : superClassDatums) {
                if (superClassDatum == classDatum) continue;
                names2.add(QVTscheduleUtil.getName((Nameable)superClassDatum));
            }
            Collections.sort(names2);
            for (String name2 : names2) {
                s.append("\n\t\t");
                s.append(name2);
            }
        }
        return s;
    }
}

