/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.debug.launching.QVTrLaunchConfigurationDelegate;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.QVTDirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.xtext.qvtcore.QVTcoreStandaloneSetup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class QVTrMainTab
extends QVTDirectionalMainTab<RelationalTransformation> {
    @Override
    protected @NonNull CompilerChain createCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull CompilerOptions options) {
        QVTcoreStandaloneSetup.class.getName();
        return new QVTrCompilerChain(environmentFactory, txURI, txURI, options);
    }

    @Override
    protected void createGenmodelGroup(Composite control) {
    }

    @Override
    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTrModelFile.gif");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull String> getIntermediateKeys() {
        @NonNull ArrayList asList = Lists.newArrayList((Object[])QVTrLaunchConfigurationDelegate.compileStepKeys);
        if (!this.isInterpreted()) {
            String[] stringArray = QVTrLaunchConfigurationDelegate.generateStepKeys;
            int n = QVTrLaunchConfigurationDelegate.generateStepKeys.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String stepKey = stringArray[n2];
                asList.add(stepKey);
                ++n2;
            }
        }
        return asList;
    }

    @Override
    protected void initializeOptions(@NonNull DefaultCompilerOptions compilerOptions) throws IOException {
        Map<@NonNull String, @NonNull URI> intermediatesMap = this.getIntermediatesMap(QVTrLaunchConfigurationDelegate.compileStepKeys);
        compilerOptions.setURIs2(QVTrLaunchConfigurationDelegate.compileStepKeys, intermediatesMap);
        compilerOptions.setDebugGraphs(this.doDotGraphs(), this.doYedGraphs());
        if (!this.isInterpreted()) {
            URI txURI = this.getTxURI();
            URI genModelURI = this.getResolvedCompilerStep("GenModel");
            URI javaURI = this.getResolvedCompilerStep("Java");
            URI classURI = this.getResolvedCompilerStep("Class");
            compilerOptions.setQVTrGenerateOptions(this.getProjectName(), txURI, genModelURI, javaURI, classURI);
        }
    }

    @Override
    protected @NonNull RelationalTransformation updateTransformation(@NonNull URI txURI) throws IOException {
        QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
        return QVTrelationUtil.loadTransformation((QVTbaseEnvironmentFactory)environmentFactory, (URI)txURI, (boolean)environmentFactory.keepDebug());
    }
}

