/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableTab
extends ExampleTab {
    private static final int INITIAL_ITEMS = 15;
    private Table table;
    private boolean headerVisible = true;
    private boolean linesVisible;
    private boolean updateVirtualItemsDelayed;
    private boolean columnImages;
    private boolean columnsMoveable;
    private int columnsWidthImages = 0;
    private int columns = 5;
    private Image columnImage;
    private Image itemImage;
    private Image smallImage;
    private Image largeImage;
    private boolean markup;

    public TableTab() {
        super("Table");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.initializeImages();
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("CHECK", 32);
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("NO_SCROLL", 16);
        this.createStyleButton("VIRTUAL", 0x10000000);
        this.createStyleButton("HIDE_SELECTION", 32768);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createHeaderVisibleButton();
        this.createHeaderForegroundControl();
        this.createHeaderBackgroundControl();
        this.createLinesVisibleButton();
        this.createColumnsMoveableButton();
        this.createColumnImagesButton();
        this.createMarkupButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createAddItemsButton();
        this.createInsertItemButton();
        this.createSelectItemButton();
        this.createDisposeFirstColumnButton();
        this.createDisposeSelectionButton();
        this.createRecreateButton();
        this.createClearButton();
        this.createTopIndexButton();
        this.createShowSelectionButton();
        this.createChangeCheckButton();
        this.createChangeGrayButton();
        this.createChangeColumnsControl();
        this.createShowColumnControl();
        this.createRevertColumnOrderButton();
        this.createPackColumnsButton();
        this.createChangeItemControl();
        this.createChangeItemCountControl();
        this.createChangeItemHeightControl();
        this.createImagesControl();
        this.createAlignmentControl();
        this.createBackgroundControl();
        this.createSelectAtPointControl();
        this.createQueryTopIndex();
        this.createItemForegroundControl();
        this.createItemBackgroundControl();
        this.createItemFontControl();
        this.createCellForegroundControl();
        this.createCellBackgroundControl();
        this.createCellFontControl();
        this.createCursorCombo();
    }

    @Override
    protected void createExampleControls(Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        int style = this.getStyle();
        this.table = new Table(parent, style);
        this.table.setData("org.eclipse.rap.rwt.markupEnabled", (Object)new Boolean(this.markup));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.log("click: " + event.item);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableTab.this.log("double-click: " + event.item);
            }
        });
        if ((style & 0x10000000) != 0) {
            this.table.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    final TableItem item = (TableItem)event.item;
                    if (TableTab.this.updateVirtualItemsDelayed) {
                        final Display display = event.display;
                        final ServerPushSession pushSession = new ServerPushSession();
                        Job job = new Job("Delayed Table Item Update"){

                            protected IStatus run(IProgressMonitor monitor) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TableTab.this.updateItem(item);
                                        pushSession.stop();
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                        };
                        pushSession.start();
                        job.schedule(1000L);
                    } else {
                        TableTab.this.updateItem(item);
                    }
                }
            });
        }
        int i = 0;
        while (i < this.columns) {
            final TableColumn column = new TableColumn(this.table, 0);
            column.setText("Column " + i);
            column.setToolTipText("Column " + i);
            if (this.columnImages) {
                column.setImage(this.columnImage);
            }
            column.setWidth(i == 0 ? 50 : 100);
            column.setMoveable(this.columnsMoveable);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Table table = column.getParent();
                    if (table.getSortColumn() == column) {
                        if (table.getSortDirection() == 128) {
                            table.setSortDirection(1024);
                        } else {
                            table.setSortDirection(128);
                        }
                    } else {
                        table.setSortDirection(128);
                        table.setSortColumn(column);
                    }
                }
            });
            ++i;
        }
        i = 0;
        while (i < 15) {
            this.addItem();
            ++i;
        }
        this.table.setSelection(0);
        this.table.setHeaderVisible(this.headerVisible);
        this.table.setLinesVisible(this.linesVisible);
        Menu menu = new Menu((Control)this.table);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("Menu for Table");
        this.table.setMenu(menu);
        this.registerControl((Control)this.table);
    }

    private void initializeImages() {
        this.columnImage = this.loadImage("resources/shell.gif");
        this.smallImage = this.loadImage("resources/newfile_wiz.gif");
        this.largeImage = this.loadImage("resources/big_image.png");
        this.itemImage = this.smallImage;
    }

    private void createHeaderVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("headerVisible");
        button.setSelection(this.headerVisible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.headerVisible = button.getSelection();
                TableTab.this.table.setHeaderVisible(TableTab.this.headerVisible);
            }
        });
    }

    private void createHeaderForegroundControl() {
        final Button button = this.createPropertyButton("Header Foreground", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Color color = button.getSelection() ? TableTab.this.fgColors[1] : null;
                TableTab.this.table.setHeaderForeground(color);
            }
        });
    }

    private void createHeaderBackgroundControl() {
        final Button button = this.createPropertyButton("Header Background", 2);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Color color = button.getSelection() ? TableTab.this.bgColors[1] : null;
                TableTab.this.table.setHeaderBackground(color);
            }
        });
    }

    private void createLinesVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("linesVisible");
        button.setSelection(this.linesVisible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.linesVisible = button.getSelection();
                TableTab.this.table.setLinesVisible(TableTab.this.linesVisible);
            }
        });
    }

    private void createColumnsMoveableButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Moveable Columns");
        button.setSelection(this.columnsMoveable);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.columnsMoveable = button.getSelection();
                TableColumn[] columns = TableTab.this.table.getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].setMoveable(TableTab.this.columnsMoveable);
                    ++i;
                }
            }
        });
    }

    protected Button createMarkupButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Markup");
        button.setSelection(this.markup);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.markup = button.getSelection();
                TableTab.this.createNew();
            }
        });
        return button;
    }

    private void createColumnImagesButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Column images");
        button.setSelection(this.columnImages);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.columnImages = button.getSelection();
                TableColumn[] columns = TableTab.this.getTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    if (TableTab.this.columnImages) {
                        columns[i].setImage(TableTab.this.columnImage);
                    } else {
                        columns[i].setImage(null);
                    }
                    ++i;
                }
            }
        });
    }

    private void createClearButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("ClearAll");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableTab.this.table.clearAll();
                TableTab.this.table.setItemCount(0);
            }
        });
    }

    private TableItem addItem() {
        TableItem result = new TableItem(this.table, 0);
        this.updateItem(result);
        return result;
    }

    private void updateItem(TableItem item) {
        if (!item.isDisposed()) {
            int index = item.getParent().indexOf(item);
            if (this.columns == 0) {
                item.setText("Item " + index);
                if (this.columnsWidthImages >= 1) {
                    item.setImage(this.itemImage);
                }
            } else {
                int i = 0;
                while (i < this.columns) {
                    item.setText(i, "Item" + index + "-" + i);
                    if (i < this.columnsWidthImages) {
                        item.setImage(i, this.itemImage);
                    }
                    ++i;
                }
            }
        }
    }

    private void createAddItemsButton() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Add");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText("1");
        Button button = new Button(composite, 8);
        button.setText("Item(s)");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int count = -1;
                try {
                    count = Integer.parseInt(text.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (count < 0) {
                    String msg = "Invalid number of TableItems: " + text.getText();
                    MessageDialog.openInformation((Shell)TableTab.this.getShell(), (String)"Information", (String)msg);
                } else {
                    int i = 0;
                    while (i < count) {
                        TableTab.this.addItem();
                        ++i;
                    }
                }
            }
        });
    }

    private void createInsertItemButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Insert On Selected Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] selectionIndices = TableTab.this.getTable().getSelectionIndices();
                if (selectionIndices.length > 0) {
                    int index = selectionIndices[0];
                    TableItem item = new TableItem(TableTab.this.getTable(), 0, index);
                    TableTab.this.updateItem(item);
                }
            }
        });
    }

    private void createSelectItemButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Select first Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TableTab.this.table.getItemCount() > 0) {
                    TableTab.this.table.setSelection(0);
                }
            }
        });
    }

    private void createDisposeFirstColumnButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Dispose first Column");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TableTab.this.getTable().getColumnCount() > 0) {
                    int firstColumn = TableTab.this.getTable().getColumnOrder()[0];
                    TableTab.this.getTable().getColumn(firstColumn).dispose();
                }
            }
        });
    }

    private void createDisposeSelectionButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Dispose Selected Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = TableTab.this.table.getSelection();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
            }
        });
    }

    private void createRecreateButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Recreate Last Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int count = TableTab.this.getTable().getItemCount();
                if (count > 0) {
                    TableItem item = TableTab.this.getTable().getItem(count - 1);
                    item.dispose();
                    item = TableTab.this.addItem();
                    item.setText("Recreated");
                }
            }
        });
    }

    private void createTopIndexButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Set topIndex = 100");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.table.setTopIndex(100);
            }
        });
    }

    private void createShowSelectionButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("showSelection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.table.showSelection();
            }
        });
    }

    private void createChangeCheckButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Change checked for selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selection = TableTab.this.table.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].setChecked(!selection[i].getChecked());
                    ++i;
                }
            }
        });
    }

    private void createChangeGrayButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Change grayed for selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] selection = TableTab.this.table.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].setGrayed(!selection[i].getGrayed());
                    ++i;
                }
            }
        });
    }

    private void createChangeColumnsControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Columns");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText(String.valueOf(this.columns));
        Button button = new Button(composite, 8);
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    TableTab.this.columns = Integer.parseInt(text.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                text.setText(String.valueOf(TableTab.this.columns));
                TableTab.this.createNew();
            }
        });
    }

    private void createShowColumnControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Column");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText(String.valueOf(this.columns - 1));
        Button button = new Button(composite, 8);
        button.setText("Show");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = Integer.parseInt(text.getText());
                    TableColumn column = TableTab.this.table.getColumn(index);
                    TableTab.this.table.showColumn(column);
                }
                catch (Exception exception) {}
            }
        });
    }

    private void createChangeItemControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label lblIndex = new Label(composite, 0);
        lblIndex.setText("Index");
        final Text txtIndex = new Text(composite, 2048);
        Util.textSizeAdjustment(lblIndex, (Control)txtIndex);
        txtIndex.setText("0");
        Label lblText = new Label(composite, 0);
        lblText.setText("Text");
        final Text txtText = new Text(composite, 2048);
        Util.textSizeAdjustment(lblText, (Control)txtText);
        Button button = new Button(composite, 8);
        GridData gridData = new GridData(1, 0x1000000, false, false, 4, -1);
        button.setLayoutData((Object)gridData);
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = Integer.parseInt(txtIndex.getText());
                    TableItem[] selection = TableTab.this.getTable().getSelection();
                    if (selection.length > 0) {
                        selection[0].setText(index, txtText.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = Integer.parseInt(txtIndex.getText());
                    TableItem[] selection = TableTab.this.getTable().getSelection();
                    if (selection.length > 0) {
                        txtText.setText(selection[0].getText(index));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private void createChangeItemCountControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblItemCount = new Label(composite, 0);
        lblItemCount.setText("ItemCount");
        final Text txtItemCount = new Text(composite, 2048);
        Util.textSizeAdjustment(lblItemCount, (Control)txtItemCount);
        txtItemCount.setText(String.valueOf(this.getTable().getItemCount()));
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Change");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int itemCount = -1;
                try {
                    itemCount = Integer.parseInt(txtItemCount.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                TableTab.this.getTable().setItemCount(itemCount);
                TableTab.this.getTable().redraw();
            }
        });
        final Button cbDelayedUpdate = new Button(composite, 32);
        GridData gridData = new GridData(16384, 0x1000000, true, false, 3, -1);
        cbDelayedUpdate.setLayoutData((Object)gridData);
        cbDelayedUpdate.setText("Update virtual items delayed");
        cbDelayedUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.updateVirtualItemsDelayed = cbDelayedUpdate.getSelection();
            }
        });
    }

    private void createChangeItemHeightControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblItemCount = new Label(composite, 0);
        lblItemCount.setText("ItemHeight");
        final Text txtItemHeight = new Text(composite, 2048);
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Change");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Integer itemHeight = null;
                try {
                    itemHeight = new Integer(Integer.parseInt(txtItemHeight.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
                TableTab.this.getTable().setData("org.eclipse.rap.rwt.customItemHeight", (Object)itemHeight);
                TableTab.this.getTable().redraw();
            }
        });
    }

    private void createRevertColumnOrderButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Revert Column Order");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] columnOrder = TableTab.this.table.getColumnOrder();
                int columnIndex = TableTab.this.table.getColumnCount() - 1;
                int i = 0;
                while (i < columnOrder.length) {
                    columnOrder[i] = columnIndex--;
                    ++i;
                }
                TableTab.this.table.setColumnOrder(columnOrder);
            }
        });
    }

    private void createPackColumnsButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Pack Columns");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn[] columns = TableTab.this.getTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].pack();
                    ++i;
                }
            }
        });
    }

    private void createImagesControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblImages = new Label(composite, 0);
        lblImages.setText("Images:");
        final Button rbSmall = new Button(composite, 16);
        rbSmall.setSelection(this.itemImage == this.smallImage);
        rbSmall.setText("Small");
        Button rbLarge = new Button(composite, 16);
        rbLarge.setSelection(this.itemImage == this.largeImage);
        rbLarge.setText("Large");
        Label lblOn = new Label(composite, 0);
        lblOn.setText("On");
        final Spinner spnCount = new Spinner(composite, 2048);
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Columns");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.columnsWidthImages = spnCount.getSelection();
                if (rbSmall.getSelection()) {
                    TableTab.this.itemImage = TableTab.this.smallImage;
                } else {
                    TableTab.this.itemImage = TableTab.this.largeImage;
                }
                int i = 0;
                while (i < TableTab.this.table.getItemCount()) {
                    int c = 0;
                    while (c < TableTab.this.table.getColumnCount()) {
                        TableItem item = TableTab.this.table.getItem(i);
                        if (c < TableTab.this.columnsWidthImages) {
                            item.setImage(c, TableTab.this.itemImage);
                        } else {
                            item.setImage(c, null);
                        }
                        ++c;
                    }
                    ++i;
                }
            }
        });
    }

    private void createAlignmentControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new RowLayout(256));
        Label label = new Label(composite, 0);
        label.setText("Alignment");
        final Combo combo = new Combo(composite, 8);
        combo.add("SWT.LEFT");
        combo.add("SWT.CENTER");
        combo.add("SWT.RIGHT");
        combo.select(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int alignment = 16384;
                if (combo.getSelectionIndex() == 1) {
                    alignment = 0x1000000;
                } else if (combo.getSelectionIndex() == 2) {
                    alignment = 131072;
                }
                TableColumn[] columns = TableTab.this.getTable().getColumns();
                int i = 0;
                while (i < columns.length) {
                    columns[i].setAlignment(alignment);
                    ++i;
                }
            }
        });
    }

    private void createBackgroundControl() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Change Item Appearance");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Display display = TableTab.this.getTable().getDisplay();
                FontData fontData = TableTab.this.getTable().getFont().getFontData()[0];
                String fontName = fontData.getName();
                Font font = new Font((Device)display, fontName, fontData.getHeight(), 1);
                Color background = display.getSystemColor(6);
                Color foreground = display.getSystemColor(14);
                TableItem[] items = TableTab.this.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    if (i % 2 == 0) {
                        items[i].setBackground(background);
                    } else {
                        items[i].setForeground(foreground);
                        items[i].setFont(font);
                    }
                    ++i;
                }
            }
        });
    }

    private void createSelectAtPointControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label lblSelectAt = new Label(composite, 0);
        lblSelectAt.setText("Select at X");
        final Text txtX = new Text(composite, 2048);
        txtX.setText("0");
        Util.textSizeAdjustment(lblSelectAt, (Control)txtX);
        Label lblY = new Label(composite, 0);
        lblY.setText("Y");
        final Text txtY = new Text(composite, 2048);
        txtY.setText("0");
        Util.textSizeAdjustment(lblY, (Control)txtY);
        Button btnSelect = new Button(composite, 8);
        btnSelect.setText("OK");
        btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int x = Integer.parseInt(txtX.getText());
                    int y = Integer.parseInt(txtY.getText());
                    Point point = new Point(x, y);
                    TableItem item = TableTab.this.getTable().getItem(point);
                    if (item != null) {
                        TableTab.this.getTable().setSelection(item);
                    } else {
                        Shell shell = TableTab.this.getTable().getShell();
                        String msg = "No table item at this coordinate.";
                        MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Shell shell = TableTab.this.getTable().getShell();
                    String msg = "Invalid x or y coordinate.";
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)msg);
                }
            }
        });
    }

    private void createQueryTopIndex() {
        Button btn = new Button(this.styleComp, 8);
        btn.setText("Query topIndex");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = TableTab.this.styleComp.getShell();
                String msg = "Current topIndex: " + TableTab.this.getTable().getTopIndex();
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
            }
        });
    }

    private void createItemForegroundControl() {
        final Button btn = new Button(this.styleComp, 2);
        btn.setText("Item 0 Foreground");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Color color = btn.getSelection() ? TableTab.this.fgColors[3] : null;
                    TableTab.this.getTable().getItem(0).setForeground(color);
                }
            }
        });
    }

    private void createItemBackgroundControl() {
        final Button btn = new Button(this.styleComp, 2);
        btn.setText("Item 0 Background");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Color color = btn.getSelection() ? TableTab.this.bgColors[3] : null;
                    TableTab.this.getTable().getItem(0).setBackground(color);
                }
            }
        });
    }

    private void createItemFontControl() {
        final Button btn = new Button(this.styleComp, 2);
        final Font customFont = new Font((Device)btn.getDisplay(), "Courier", 11, 1);
        btn.setText("Item 0 Font");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Font font = btn.getSelection() ? customFont : null;
                    TableTab.this.getTable().getItem(0).setFont(font);
                }
            }
        });
    }

    private void createCellForegroundControl() {
        final Button btn = new Button(this.styleComp, 2);
        btn.setText("Cell 0,0 Foreground");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Color color = btn.getSelection() ? TableTab.this.fgColors[1] : null;
                    TableTab.this.getTable().getItem(0).setForeground(0, color);
                }
            }
        });
    }

    private void createCellBackgroundControl() {
        final Button btn = new Button(this.styleComp, 2);
        btn.setText("Cell 0,0 Background");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Color color = btn.getSelection() ? TableTab.this.bgColors[1] : null;
                    TableTab.this.getTable().getItem(0).setBackground(0, color);
                }
            }
        });
    }

    private void createCellFontControl() {
        final Button btn = new Button(this.styleComp, 2);
        final Font cellFont = new Font((Device)btn.getDisplay(), "Times", 13, 2);
        btn.setText("Cell 0,0 Font");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TableTab.this.getTable().getItemCount() > 0) {
                    Font font = btn.getSelection() ? cellFont : null;
                    TableTab.this.getTable().getItem(0).setFont(0, font);
                }
            }
        });
    }

    private Table getTable() {
        return this.table;
    }
}

