/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementWrapper;
import org.eclipse.jface.viewers.IElementComparer;

public class ViewerElementMap<K, V>
implements Map<K, V> {
    private Map<ViewerElementWrapper<K>, V> wrappedMap;
    private IElementComparer comparer;

    public ViewerElementMap(IElementComparer comparer) {
        Assert.isNotNull((Object)comparer);
        this.wrappedMap = new HashMap<ViewerElementWrapper<K>, V>();
        this.comparer = comparer;
    }

    public ViewerElementMap(Map<? extends K, ? extends V> map, IElementComparer comparer) {
        this(comparer);
        Assert.isNotNull(map);
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(new ViewerElementWrapper<Object>(key, this.comparer));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<ViewerElementWrapper<K>, V>> wrappedEntrySet = this.wrappedMap.entrySet();
        return new Set<Map.Entry<K, V>>(){

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                wrappedEntrySet.clear();
            }

            @Override
            public boolean contains(Object o) {
                for (Map.Entry element : this) {
                    if (!((Object)element).equals(o)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object element : c) {
                    if (this.contains(element)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return wrappedEntrySet.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator wrappedIterator = wrappedEntrySet.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry wrappedEntry = (Map.Entry)wrappedIterator.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ((ViewerElementWrapper)wrappedEntry.getKey()).unwrap();
                            }

                            @Override
                            public V getValue() {
                                return wrappedEntry.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return wrappedEntry.setValue(value);
                            }

                            @Override
                            public boolean equals(Object obj) {
                                if (obj == this) {
                                    return true;
                                }
                                if (obj == null || !(obj instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry that = (Map.Entry)obj;
                                return ViewerElementMap.this.comparer.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
                            }

                            @Override
                            public int hashCode() {
                                return wrappedEntry.hashCode();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        wrappedIterator.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                final Map.Entry unwrappedEntry = (Map.Entry)o;
                final ViewerElementWrapper wrappedKey = new ViewerElementWrapper(unwrappedEntry.getKey(), ViewerElementMap.this.comparer);
                Map.Entry<Object, Object> wrappedEntry = new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return wrappedKey;
                    }

                    @Override
                    public Object getValue() {
                        return unwrappedEntry.getValue();
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean equals(Object obj) {
                        if (obj == this) {
                            return true;
                        }
                        if (obj == null || !(obj instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry that = (Map.Entry)obj;
                        return Objects.equals(wrappedKey, that.getKey()) && Objects.equals(this.getValue(), that.getValue());
                    }

                    @Override
                    public int hashCode() {
                        return wrappedKey.hashCode() ^ Objects.hashCode(this.getValue());
                    }
                };
                return wrappedEntrySet.remove(wrappedEntry);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object element : c) {
                    changed |= this.remove(element);
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean changed = false;
                Object[] toRetains = c.toArray();
                Iterator iterator = this.iterator();
                block0: while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object[] objectArray = toRetains;
                    int n = toRetains.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object toRetain = objectArray[n2];
                        if (((Object)entry).equals(toRetain)) continue block0;
                        ++n2;
                    }
                    iterator.remove();
                    changed = true;
                }
                return changed;
            }

            @Override
            public int size() {
                return wrappedEntrySet.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Object[this.size()]);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int i = 0;
                for (Map.Entry entry : this) {
                    a[i] = entry;
                    ++i;
                }
                return a;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !(obj instanceof Set)) {
                    return false;
                }
                Set that = (Set)obj;
                return this.size() == that.size() && this.containsAll(that);
            }

            @Override
            public int hashCode() {
                return wrappedEntrySet.hashCode();
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(new ViewerElementWrapper<Object>(key, this.comparer));
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        final Set<ViewerElementWrapper<K>> wrappedKeySet = this.wrappedMap.keySet();
        return new Set<K>(){

            @Override
            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                wrappedKeySet.clear();
            }

            @Override
            public boolean contains(Object o) {
                return wrappedKeySet.contains(new ViewerElementWrapper<Object>(o, ViewerElementMap.this.comparer));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object element : c) {
                    if (wrappedKeySet.contains(new ViewerElementWrapper(element, ViewerElementMap.this.comparer))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return wrappedKeySet.isEmpty();
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator wrappedIterator = wrappedKeySet.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((ViewerElementWrapper)wrappedIterator.next()).unwrap();
                    }

                    @Override
                    public void remove() {
                        wrappedIterator.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                return wrappedKeySet.remove(new ViewerElementWrapper<Object>(o, ViewerElementMap.this.comparer));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object element : c) {
                    changed |= wrappedKeySet.remove(new ViewerElementWrapper(element, ViewerElementMap.this.comparer));
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean changed = false;
                Object[] toRetains = c.toArray();
                block0: for (Object element : this) {
                    Object[] objectArray = toRetains;
                    int n = toRetains.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object toRetain = objectArray[n2];
                        if (ViewerElementMap.this.comparer.equals(element, toRetain)) continue block0;
                        ++n2;
                    }
                    this.remove(element);
                    changed = true;
                }
                return changed;
            }

            @Override
            public int size() {
                return wrappedKeySet.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Object[wrappedKeySet.size()]);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = wrappedKeySet.size();
                ViewerElementWrapper[] wrappedArray = wrappedKeySet.toArray(new ViewerElementWrapper[size]);
                Object[] result = a;
                if (a.length < size) {
                    result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int i = 0;
                while (i < size) {
                    result[i] = wrappedArray[i].unwrap();
                    ++i;
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !(obj instanceof Set)) {
                    return false;
                }
                Set that = (Set)obj;
                return this.size() == that.size() && this.containsAll(that);
            }

            @Override
            public int hashCode() {
                return wrappedKeySet.hashCode();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        return this.wrappedMap.put(new ViewerElementWrapper<K>(key, this.comparer), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> other) {
        for (Map.Entry<K, V> entry : other.entrySet()) {
            this.wrappedMap.put(new ViewerElementWrapper<K>(entry.getKey(), this.comparer), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.wrappedMap.remove(new ViewerElementWrapper<Object>(key, this.comparer));
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.wrappedMap.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map that = (Map)obj;
        return this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.wrappedMap.hashCode();
    }

    public static <K, V> Map<K, V> withComparer(IElementComparer comparer) {
        if (comparer == null) {
            return new HashMap();
        }
        return new ViewerElementMap<K, V>(comparer);
    }
}

