/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeScrollDropListener
extends DropTargetAdapter {
    private Tree tree;

    public TreeScrollDropListener(Tree tree) {
        this.tree = tree;
    }

    public void dragOver(DropTargetEvent event) {
        Point point = this.tree.toControl(new Point(event.x, event.y));
        TreeItem item = this.tree.getItem(point);
        if (item == null) {
            return;
        }
        Rectangle clientArea = this.tree.getClientArea();
        int scrollRegionSize = Math.min(clientArea.height / 3, 24);
        if (scrollRegionSize < 8) {
            return;
        }
        TreeItem showItem = item;
        do {
            if (point.y < clientArea.y + scrollRegionSize) {
                showItem = this.getPreviousVisibleItem(this.tree, showItem);
            } else {
                if (point.y <= clientArea.height + clientArea.y - scrollRegionSize) break;
                showItem = this.getNextVisibleItem(this.tree, showItem, false);
            }
            if (showItem == null) break;
            this.tree.showItem(showItem);
        } while (item == this.tree.getItem(point));
    }

    private TreeItem getLastVisibleChild(TreeItem item) {
        if (!item.getExpanded()) {
            return item;
        }
        TreeItem[] items = item.getItems();
        if (items == null || items.length == 0) {
            return item;
        }
        return this.getLastVisibleChild(items[items.length - 1]);
    }

    private TreeItem getNextVisibleItem(Tree tree, TreeItem item, boolean ignoreChildren) {
        TreeItem[] items;
        TreeItem parent = item.getParentItem();
        TreeItem[] treeItemArray = items = parent != null ? parent.getItems() : tree.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] == item) {
                    TreeItem[] children;
                    if (!ignoreChildren && items[i].getExpanded() && (children = items[i].getItems()) != null && children.length > 0) {
                        return children[0];
                    }
                    if (i + 1 >= items.length) break;
                    return items[i + 1];
                }
                ++i;
            }
            if (parent != null) {
                return this.getNextVisibleItem(tree, parent, true);
            }
        }
        return null;
    }

    private TreeItem getPreviousVisibleItem(Tree tree, TreeItem item) {
        TreeItem[] items;
        TreeItem parent = item.getParentItem();
        TreeItem[] treeItemArray = items = parent != null ? parent.getItems() : tree.getItems();
        if (items != null) {
            int i = items.length - 1;
            while (i > 0) {
                if (items[i] == item) {
                    return this.getLastVisibleChild(items[i - 1]);
                }
                --i;
            }
        }
        return parent;
    }
}

