/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemResourceVariant;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ThreeWayResourceComparator;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.internal.core.mapping.LocalResourceVariant;

public class RSEResourceVariantComparator
extends ThreeWayResourceComparator {
    private ThreeWaySynchronizer _synchronizer;

    public RSEResourceVariantComparator(ThreeWaySynchronizer synchronizer) {
        super(synchronizer);
        this._synchronizer = synchronizer;
    }

    public boolean compare(IResource local, IResourceVariant remote) {
        if (local instanceof IContainer) {
            return remote.isContainer();
        }
        if (local instanceof IFile && remote instanceof FileSystemResourceVariant) {
            FileSystemResourceVariant myE2 = (FileSystemResourceVariant)remote;
            myE2.synchRemoteFile();
            SystemIFileProperties properties = new SystemIFileProperties(local);
            long remoteTimeStamp = myE2.lastModified();
            if (remoteTimeStamp == 0L) {
                properties.setRemoteFileTimeStamp(0L);
                properties.setDownloadFileTimeStamp(0L);
                return false;
            }
            long storedTimeStamp = properties.getRemoteFileTimeStamp();
            long storedLocalTimeStamp = properties.getDownloadFileTimeStamp();
            long localTimeStamp = local.getLocalTimeStamp();
            if (storedTimeStamp == 0L) {
                properties.setRemoteFileTimeStamp(remoteTimeStamp);
                properties.setDownloadFileTimeStamp(local.getLocalTimeStamp());
                storedTimeStamp = remoteTimeStamp;
                storedLocalTimeStamp = localTimeStamp;
            }
            boolean result = storedTimeStamp == remoteTimeStamp && storedLocalTimeStamp == localTimeStamp;
            return result;
        }
        return local instanceof IFile && remote instanceof LocalResourceVariant;
    }

    public boolean compare(IResourceVariant e1, IResourceVariant e2) {
        if (e1.isContainer()) {
            return e2.isContainer();
        }
        if (e1 instanceof FileSystemResourceVariant && e2 instanceof FileSystemResourceVariant) {
            FileSystemResourceVariant myE1 = (FileSystemResourceVariant)e1;
            FileSystemResourceVariant myE2 = (FileSystemResourceVariant)e2;
            return myE1.lastModified() == myE2.lastModified();
        }
        return false;
    }

    private byte[] getBytes(IResourceVariant remote) {
        return remote.asBytes();
    }

    private boolean equals(byte[] syncBytes, byte[] oldBytes) {
        if (syncBytes == null || oldBytes == null) {
            return false;
        }
        if (syncBytes.length != oldBytes.length) {
            return false;
        }
        int i = 0;
        while (i < oldBytes.length) {
            if (oldBytes[i] != syncBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equalSize(IResource local, IResourceVariant remote) {
        long localSize = local.getLocation().toFile().length();
        long remoteSize = 0L;
        if (remote instanceof FileSystemResourceVariant) {
            remoteSize = ((FileSystemResourceVariant)remote).getFile().length();
        }
        return localSize == remoteSize;
    }
}

