/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards;

import java.util.Vector;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorProfileName;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SystemNewProfileWizardMainPage
extends AbstractSystemWizardPage
implements ISystemMessageLine {
    private String profileName;
    private Text textName;
    private Button makeActiveCB;
    private boolean makeActive;
    private SystemMessage errorMessage;
    protected ISystemValidator nameValidator;
    private static final String HELPID_PREFIX = "org.eclipse.rse.ui.wnpr";

    public SystemNewProfileWizardMainPage(Wizard wizard) {
        super((IWizard)wizard, "NewProfile", SystemResources.RESID_NEWPROFILE_PAGE1_TITLE, SystemResources.RESID_NEWPROFILE_PAGE1_DESCRIPTION);
        ISystemProfile[] profiles = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getSystemProfiles();
        Vector<String> profileNames = new Vector<String>(profiles.length);
        int i = 0;
        while (i < profiles.length) {
            profileNames.add(profiles[i].getName());
            ++i;
        }
        this.nameValidator = new ValidatorProfileName(profileNames);
        this.setHelp("org.eclipse.rse.ui.wnpr0000");
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        this.textName = SystemWidgetHelpers.createLabeledTextField(composite_prompts, null, SystemResources.RESID_NEWPROFILE_NAME_LABEL, SystemResources.RESID_NEWPROFILE_NAME_TOOLTIP);
        this.textName.setTextLimit(100);
        SystemWidgetHelpers.setHelp((Control)this.textName, "org.eclipse.rse.ui.wnpr0001");
        this.makeActiveCB = SystemWidgetHelpers.createCheckBox(composite_prompts, nbrColumns, null, SystemResources.RESID_NEWPROFILE_MAKEACTIVE_LABEL, SystemResources.RESID_NEWPROFILE_MAKEACTIVE_TOOLTIP);
        this.makeActiveCB.setSelection(true);
        SystemWidgetHelpers.setHelp((Control)this.makeActiveCB, "org.eclipse.rse.ui.wnpr0002");
        this.addGrowableFillerLine(composite_prompts, nbrColumns);
        this.addSeparatorLine(composite_prompts, nbrColumns);
        SystemWidgetHelpers.createVerbiage(composite_prompts, SystemResources.RESID_NEWPROFILE_VERBIAGE, nbrColumns, false, 200);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemNewProfileWizardMainPage.this.validateNameInput();
            }
        });
        return composite_prompts;
    }

    protected Control getInitialFocusControl() {
        return this.textName;
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = this.nameValidator.validate(this.textName.getText());
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        this.setPageComplete(this.errorMessage == null);
        return this.errorMessage;
    }

    public boolean performFinish() {
        boolean ok;
        boolean bl = ok = this.validateNameInput() == null;
        if (ok) {
            this.profileName = this.textName.getText().trim();
            this.makeActive = this.makeActiveCB.getSelection();
        }
        return ok;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean getMakeActive() {
        return this.makeActive;
    }

    public Object getLayoutData() {
        return null;
    }

    public void setLayoutData(Object gridData) {
    }

    public boolean isPageComplete() {
        return this.textName.getText().trim().length() > 0;
    }
}

