/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public final class ISequenceElementAccessor {
    private ISequenceElementAccessor() {
    }

    public static Option<ISequenceElement> getISequenceElement(View notationView) {
        return ISequenceElementAccessor.getOrCreate(notationView, ISequenceElement.class);
    }

    public static boolean isPartOfSequenceElement(View notationView) {
        boolean isPartOfSequenceElement = false;
        View view = notationView;
        if (view.eContainer() instanceof View && (CombinedFragment.compartmentNotationPredicate().apply((Object)view) || Operand.compartmentNotationPredicate().apply((Object)view))) {
            view = (View)view.eContainer();
        }
        Option<ISequenceElement> sequenceElementOption = ISequenceElementAccessor.getISequenceElement(view);
        isPartOfSequenceElement = sequenceElementOption.some();
        return isPartOfSequenceElement;
    }

    public static Option<SequenceDiagram> getSequenceDiagram(Diagram diagramView) {
        return ISequenceElementAccessor.getOrCreate((View)diagramView, SequenceDiagram.class);
    }

    public static Option<ISequenceEvent> getISequenceEvent(View view) {
        return ISequenceElementAccessor.getOrCreate(view, ISequenceEvent.class);
    }

    public static Option<ISequenceNode> getISequenceNode(View view) {
        return ISequenceElementAccessor.getOrCreate(view, ISequenceNode.class);
    }

    public static Option<InstanceRole> getInstanceRole(View view) {
        return ISequenceElementAccessor.getOrCreate(view, InstanceRole.class);
    }

    public static Option<Lifeline> getLifeline(View view) {
        return ISequenceElementAccessor.getOrCreate(view, Lifeline.class);
    }

    public static Option<EndOfLife> getEndOfLife(View view) {
        return ISequenceElementAccessor.getOrCreate(view, EndOfLife.class);
    }

    public static Option<AbstractNodeEvent> getAbstractNodeEvent(View view) {
        return ISequenceElementAccessor.getOrCreate(view, AbstractNodeEvent.class);
    }

    public static Option<Execution> getExecution(View view) {
        return ISequenceElementAccessor.getOrCreate(view, Execution.class);
    }

    public static Option<State> getState(View view) {
        return ISequenceElementAccessor.getOrCreate(view, State.class);
    }

    public static Option<Message> getMessage(View view) {
        return ISequenceElementAccessor.getOrCreate(view, Message.class);
    }

    public static Option<InteractionUse> getInteractionUse(View view) {
        return ISequenceElementAccessor.getOrCreate(view, InteractionUse.class);
    }

    public static Option<CombinedFragment> getCombinedFragment(View view) {
        return ISequenceElementAccessor.getOrCreate(view, CombinedFragment.class);
    }

    public static Option<Operand> getOperand(View view) {
        return ISequenceElementAccessor.getOrCreate(view, Operand.class);
    }

    public static Option<LostMessageEnd> getLostMessageEnd(View view) {
        return ISequenceElementAccessor.getOrCreate(view, LostMessageEnd.class);
    }

    public static Option<ObservationPoint> getObservationPoint(View view) {
        return ISequenceElementAccessor.getOrCreate(view, ObservationPoint.class);
    }

    private static <T extends ISequenceElement> Option<T> getOrCreate(View notationView, Class<T> expectedType) {
        ISequenceElement ise = null;
        if (notationView != null) {
            UnmodifiableIterator it = Iterators.filter((Iterator)notationView.eAdapters().iterator(), ISequenceElement.class);
            if (it.hasNext()) {
                ISequenceElement seqElt = (ISequenceElement)it.next();
                if (expectedType.isInstance(seqElt)) {
                    ise = (ISequenceElement)expectedType.cast(seqElt);
                }
            } else {
                ISequenceElement element = ISequenceElementAccessor.createSequenceElement(notationView);
                if (element != null && expectedType.isInstance(element)) {
                    ise = (ISequenceElement)expectedType.cast(element);
                }
            }
        }
        return Options.newSome(ise);
    }

    private static ISequenceElement createSequenceElement(View notationView) {
        AbstractSequenceElement created = null;
        if (SequenceDiagram.notationPredicate().apply((Object)notationView)) {
            created = new SequenceDiagram((Diagram)notationView);
        } else if (InstanceRole.notationPredicate().apply((Object)notationView)) {
            created = new InstanceRole((Node)notationView);
        } else if (Lifeline.notationPredicate().apply((Object)notationView)) {
            created = new Lifeline((Node)notationView);
        } else if (EndOfLife.notationPredicate().apply((Object)notationView)) {
            created = new EndOfLife((Node)notationView);
        } else if (Execution.notationPredicate().apply((Object)notationView)) {
            created = new Execution((Node)notationView);
        } else if (State.notationPredicate().apply((Object)notationView)) {
            created = new State((Node)notationView);
        } else if (Message.notationPredicate().apply((Object)notationView)) {
            created = new Message((Edge)notationView);
        } else if (CombinedFragment.notationPredicate().apply((Object)notationView)) {
            created = new CombinedFragment((Node)notationView);
        } else if (Operand.notationPredicate().apply((Object)notationView)) {
            created = new Operand((Node)notationView);
        } else if (InteractionUse.notationPredicate().apply((Object)notationView)) {
            created = new InteractionUse((Node)notationView);
        } else if (LostMessageEnd.notationPredicate().apply((Object)notationView)) {
            created = new LostMessageEnd((Node)notationView);
        } else if (ObservationPoint.notationPredicate().apply((Object)notationView)) {
            created = new ObservationPoint((Node)notationView);
        }
        if (created != null) {
            notationView.eAdapters().add((Object)created);
        }
        return created;
    }

    public static Collection<ISequenceEvent> getEventsForSemanticElement(SequenceDiagram diagram, EObject semanticElement) {
        ECrossReferenceAdapter xref = ISequenceElementAccessor.getCrossReferencer(semanticElement);
        if (xref == null) {
            return Collections.emptySet();
        }
        ArrayList<ISequenceEvent> result = new ArrayList<ISequenceEvent>();
        for (EStructuralFeature.Setting setting : xref.getInverseReferences(semanticElement)) {
            Option<ISequenceEvent> elt;
            DDiagramElement dde;
            Option<View> optView;
            if (!ISequenceElementAccessor.isDiagramElementTargetReference(setting) || !(optView = ISequenceElementAccessor.getGMFView((DSemanticDecorator)(dde = (DDiagramElement)setting.getEObject()), xref)).some() || !(elt = ISequenceElementAccessor.getISequenceEvent((View)optView.get())).some() || !diagram.equals(((ISequenceEvent)elt.get()).getDiagram())) continue;
            result.add((ISequenceEvent)elt.get());
        }
        return result;
    }

    public static Collection<View> getViewsForSemanticElement(SequenceDDiagram diagram, EObject semanticElement) {
        ECrossReferenceAdapter xref = ISequenceElementAccessor.getCrossReferencer(semanticElement);
        if (xref == null || diagram == null) {
            return Collections.emptySet();
        }
        ArrayList<View> result = new ArrayList<View>();
        for (EStructuralFeature.Setting setting : xref.getInverseReferences(semanticElement)) {
            DSemanticDiagram foundDiag;
            Option<View> optView;
            if (ISequenceElementAccessor.isDiagramElementTargetReference(setting)) {
                DDiagramElement dde = (DDiagramElement)setting.getEObject();
                optView = ISequenceElementAccessor.getGMFView((DSemanticDecorator)dde, xref);
                if (!optView.some() || !diagram.equals(dde.getParentDiagram())) continue;
                result.add((View)optView.get());
                continue;
            }
            if (!ISequenceElementAccessor.isDiagramTargetReference(setting) || !(optView = ISequenceElementAccessor.getGMFView((DSemanticDecorator)(foundDiag = (DSemanticDiagram)setting.getEObject()), xref)).some() || !diagram.equals(foundDiag)) continue;
            result.add((View)optView.get());
        }
        return result;
    }

    public static Collection<DDiagramElement> getDiagramElementsForSemanticElement(SequenceDiagram diagram, EObject semanticElement) {
        ECrossReferenceAdapter xref = ISequenceElementAccessor.getCrossReferencer(semanticElement);
        if (xref == null) {
            return Collections.emptySet();
        }
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        for (EStructuralFeature.Setting setting : xref.getInverseReferences(semanticElement)) {
            if (!ISequenceElementAccessor.isDiagramElementTargetReference(setting)) continue;
            result.add((DDiagramElement)setting.getEObject());
        }
        return result;
    }

    private static Option<View> getGMFView(DSemanticDecorator dSem, ECrossReferenceAdapter xref) {
        for (EStructuralFeature.Setting setting : xref.getInverseReferences((EObject)dSem)) {
            EObject view;
            if (!ISequenceElementAccessor.isViewElementReference(setting) || !((view = setting.getEObject()) instanceof View) || ((View)view).getDiagram() == null) continue;
            return Options.newSome((Object)((View)view));
        }
        return Options.newNone();
    }

    private static boolean isViewElementReference(EStructuralFeature.Setting setting) {
        EReference elementRef = NotationPackage.eINSTANCE.getView_Element();
        return setting.getEObject() instanceof View && setting.getEStructuralFeature().equals(elementRef);
    }

    private static boolean isDiagramElementTargetReference(EStructuralFeature.Setting setting) {
        EReference targetReference = ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target();
        return setting.getEObject() instanceof DDiagramElement && setting.getEStructuralFeature().equals(targetReference);
    }

    private static boolean isDiagramTargetReference(EStructuralFeature.Setting setting) {
        EReference targetReference = ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target();
        return setting.getEObject() instanceof DDiagram && setting.getEStructuralFeature().equals(targetReference);
    }

    private static ECrossReferenceAdapter getCrossReferencer(EObject semanticElement) {
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        if (session != null) {
            return session.getSemanticCrossReferencer();
        }
        return null;
    }
}

