/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import com.google.common.base.Predicate;
import java.util.Collection;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.ext.base.Option;

public class SameLifelinePredicate
implements Predicate<ISequenceEvent> {
    private Lifeline owner;

    public SameLifelinePredicate(Lifeline owner) {
        assert (owner != null);
        this.owner = owner;
    }

    public boolean apply(ISequenceEvent input) {
        boolean result = false;
        Option<Lifeline> inputLifeline = input.getLifeline();
        if (inputLifeline.some()) {
            result = ((Lifeline)inputLifeline.get()).equals(this.owner);
        } else if (input instanceof Message) {
            Message message = (Message)input;
            ISequenceNode sourceElt = message.getSourceElement();
            ISequenceNode targetElt = message.getSourceElement();
            Option<Lifeline> sourceLifeline = sourceElt.getLifeline();
            Option<Lifeline> targetLifeline = targetElt.getLifeline();
            result = sourceLifeline.some() && ((Lifeline)sourceLifeline.get()).equals(this.owner) || targetLifeline.some() && ((Lifeline)targetLifeline.get()).equals(this.owner);
        } else if (input instanceof Operand) {
            result = true;
        } else if (input instanceof AbstractFrame) {
            AbstractFrame frame = (AbstractFrame)input;
            Collection<Lifeline> coverage = frame.computeCoveredLifelines();
            result = coverage.contains(this.owner);
        }
        return result;
    }
}

