/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.api.layout;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.description.BooleanLayoutOption;
import org.eclipse.sirius.diagram.description.DescriptionFactory;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DoubleLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.EnumSetLayoutOption;
import org.eclipse.sirius.diagram.description.IntegerLayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.description.LayoutOptionTarget;
import org.eclipse.sirius.diagram.description.StringLayoutOption;
import org.eclipse.sirius.diagram.ui.api.layout.EnumChoice;

public class LayoutOptionFactory {
    public LayoutOption createEnumSetOption(List<EnumChoice> choices, String id, String description, String label, List<String> defaultValues, Set<LayoutOptionTarget> targets) {
        EnumSetLayoutOption layoutOption = DescriptionFactory.eINSTANCE.createEnumSetLayoutOption();
        layoutOption.setDescription(description);
        layoutOption.setLabel(label);
        layoutOption.setId(id);
        layoutOption.getTargets().addAll(targets);
        for (EnumChoice enumChoice : choices) {
            EnumLayoutValue layoutValue = DescriptionFactory.eINSTANCE.createEnumLayoutValue();
            layoutValue.setDescription(enumChoice.getDescription());
            layoutValue.setName(enumChoice.getName());
            layoutOption.getChoices().add((Object)layoutValue);
            if (!defaultValues.contains(enumChoice.getName())) continue;
            layoutOption.getValues().add((Object)((EnumLayoutValue)EcoreUtil.copy((EObject)layoutValue)));
        }
        return layoutOption;
    }

    public LayoutOption createEnumOption(List<EnumChoice> choices, String id, String description, String label, String defaultValue, Set<LayoutOptionTarget> targets) {
        EnumLayoutOption layoutOption = DescriptionFactory.eINSTANCE.createEnumLayoutOption();
        layoutOption.setDescription(description);
        layoutOption.setLabel(label);
        layoutOption.setId(id);
        layoutOption.getTargets().addAll(targets);
        for (EnumChoice enumChoice : choices) {
            EnumLayoutValue layoutValue = DescriptionFactory.eINSTANCE.createEnumLayoutValue();
            layoutValue.setDescription(enumChoice.getDescription());
            layoutValue.setName(enumChoice.getName());
            if (defaultValue.equals(enumChoice.getName())) {
                layoutOption.setValue(layoutValue);
            }
            layoutOption.getChoices().add((Object)((EnumLayoutValue)EcoreUtil.copy((EObject)layoutValue)));
        }
        return layoutOption;
    }

    public LayoutOption createStringOption(String defaultValue, String id, String description, String label, Set<LayoutOptionTarget> targets) {
        StringLayoutOption layoutOption = DescriptionFactory.eINSTANCE.createStringLayoutOption();
        this.setCommonAttributes(id, description, label, (LayoutOption)layoutOption, targets);
        if (defaultValue != null) {
            layoutOption.setValue(defaultValue);
        }
        return layoutOption;
    }

    public LayoutOption createIntegerOption(Integer defaultValue, String id, String description, String label, Set<LayoutOptionTarget> targets) {
        IntegerLayoutOption layoutOption = DescriptionFactory.eINSTANCE.createIntegerLayoutOption();
        this.setCommonAttributes(id, description, label, (LayoutOption)layoutOption, targets);
        if (defaultValue != null) {
            layoutOption.setValue(defaultValue.intValue());
        }
        return layoutOption;
    }

    public LayoutOption createDoubleOption(Double defaultValue, String id, String description, String label, Set<LayoutOptionTarget> targets) {
        DoubleLayoutOption layoutOption = DescriptionFactory.eINSTANCE.createDoubleLayoutOption();
        this.setCommonAttributes(id, description, label, (LayoutOption)layoutOption, targets);
        if (defaultValue != null) {
            layoutOption.setValue(defaultValue.doubleValue());
        }
        return layoutOption;
    }

    private void setCommonAttributes(String id, String description, String label, LayoutOption layoutOption, Set<LayoutOptionTarget> targets) {
        layoutOption.setId(id);
        layoutOption.setLabel(label);
        layoutOption.setDescription(description);
        layoutOption.getTargets().addAll(targets);
    }

    public LayoutOption createBooleanOption(Boolean defaultValue, String id, String description, String label, Set<LayoutOptionTarget> targets) {
        BooleanLayoutOption layoutOption = (BooleanLayoutOption)EcoreUtil.create((EClass)DescriptionPackage.eINSTANCE.getBooleanLayoutOption());
        this.setCommonAttributes(id, description, label, (LayoutOption)layoutOption, targets);
        if (defaultValue != null) {
            layoutOption.setValue(defaultValue.booleanValue());
        }
        return layoutOption;
    }
}

