/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.TextStyle;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.internal.view.factories.SiriusNoteViewFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class NoteShapeDefaultLabelAlignmentMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("14.5.1.202106111100");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (Shape noteShape : this.getNoteShapes(dAnalysis)) {
                EAnnotation specificStyles = noteShape.getEAnnotation("specificStyles");
                if (specificStyles == null) {
                    specificStyles = SiriusNoteViewFactory.createDefaultVerticalAlignmentEAnnotation();
                    noteShape.getEAnnotations().add((Object)specificStyles);
                    for (TextStyle textStyle : Iterables.filter((Iterable)noteShape.getStyles(), TextStyle.class)) {
                        if (TextAlignment.LEFT_LITERAL != textStyle.getTextAlignment()) continue;
                        textStyle.setTextAlignment(TextAlignment.CENTER_LITERAL);
                    }
                    continue;
                }
                if (SiriusNoteViewFactory.hasDefaultVerticalAlignment(specificStyles)) continue;
                SiriusNoteViewFactory.addDefaultVerticalAlignment(specificStyles);
            }
        }
    }

    private Collection<DDiagram> getDiagrams(DAnalysis dAnalysis) {
        HashSet<DDiagram> diagrams = new HashSet<DDiagram>();
        for (DView view : dAnalysis.getOwnedViews()) {
            Iterables.addAll(diagrams, (Iterable)Iterables.filter((Iterable)new DViewQuery(view).getLoadedRepresentations(), DDiagram.class));
        }
        return diagrams;
    }

    private Collection<Shape> getNoteShapes(DAnalysis dAnalysis) {
        HashSet<Shape> shapes = new HashSet<Shape>();
        for (DDiagram dDiagram : this.getDiagrams(dAnalysis)) {
            shapes.addAll(this.getNoteShapes(dDiagram));
        }
        return shapes;
    }

    private Collection<Shape> getNoteShapes(DDiagram dDiagram) {
        HashSet<Shape> shapes = new HashSet<Shape>();
        DDiagramGraphicalQuery query = new DDiagramGraphicalQuery(dDiagram);
        Option<Diagram> gmfDiagram = query.getAssociatedGMFDiagram();
        if (gmfDiagram.some()) {
            for (Shape shape : Iterables.filter((Iterable)((Diagram)gmfDiagram.get()).getChildren(), Shape.class)) {
                if (!ViewType.NOTE.equals(shape.getType())) continue;
                shapes.add(shape);
            }
        }
        return shapes;
    }
}

