/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class SiriusScroller
extends ViewportAutoexposeHelper {
    public static final Insets VIEWPOINT_SCROLLER_INSETS = new Insets(50);
    private static final Insets DEFAULT_EXPOSE_THRESHOLD = new Insets(200);
    private static final int MAXIMUM_MULTIPLICATOR = 8;
    private static final int DISTANCE_THAT_INCREASE_MULTIPLICATOR = 20;
    private long lastStepTime;
    private Insets threshold;

    public SiriusScroller(GraphicalEditPart owner) {
        super(owner);
        this.threshold = DEFAULT_EXPOSE_THRESHOLD;
    }

    public SiriusScroller(GraphicalEditPart owner, Insets threshold) {
        super(owner);
        this.threshold = threshold;
    }

    public boolean detect(Point where) {
        this.lastStepTime = 0L;
        Viewport port = this.findViewport(this.owner);
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        return rect.contains(where) && !rect.shrink(this.threshold).contains(where);
    }

    public boolean step(Point where) {
        Viewport port = this.findViewport(this.owner);
        Option<Point> loc = this.calculateScroll(port, where);
        if (loc.some()) {
            port.setViewLocation((Point)loc.get());
        }
        return true;
    }

    public Option<Point> calculateScroll(Viewport port, Point where) {
        long difference;
        Option result = Options.newNone();
        int multiplicator = 1;
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        if (!rect.contains(where) || rect.shrink(this.threshold).contains(where)) {
            multiplicator = this.calculateMultiplicator(port, where);
        }
        int scrollOffset = 0;
        if (this.lastStepTime == 0L) {
            this.lastStepTime = System.currentTimeMillis();
        }
        if ((difference = System.currentTimeMillis() - this.lastStepTime) > 0L) {
            scrollOffset = (int)difference / 3;
            this.lastStepTime = System.currentTimeMillis();
        }
        if (scrollOffset != 0) {
            scrollOffset = multiplicator * scrollOffset;
            rect.shrink(this.threshold);
            int region = rect.getPosition(where);
            Point loc = port.getViewLocation();
            loc = this.updateLocationAccordingToPosition(scrollOffset, region, loc);
            result = Options.newSome((Object)loc);
        }
        return result;
    }

    private int calculateMultiplicator(Viewport port, Point where) {
        int candidateMultiplicator;
        double bottomDistance;
        double topDistance;
        int mutliplicator = 1;
        double maximalDistance = 0.0;
        if (where.x < port.getBounds().x) {
            maximalDistance = Math.abs(port.getBounds().x - where.x);
        }
        if (where.x > port.getBounds().x + port.getBounds().width) {
            maximalDistance = where.x - (port.getBounds().x + port.getBounds().width);
        }
        if (where.y < port.getBounds().y && (topDistance = (double)Math.abs(port.getBounds().y - where.y)) > maximalDistance) {
            maximalDistance = topDistance;
        }
        if (where.y > port.getBounds().y + port.getBounds().height && (bottomDistance = (double)(where.y - (port.getBounds().y + port.getBounds().height))) > maximalDistance) {
            maximalDistance = bottomDistance;
        }
        if ((candidateMultiplicator = (int)maximalDistance / 20 + 1) > mutliplicator) {
            mutliplicator = Math.min(8, candidateMultiplicator);
        }
        return mutliplicator;
    }

    private Point updateLocationAccordingToPosition(int scrollOffset, int region, Point loc) {
        Point result = loc;
        if ((region & 4) != 0) {
            result.setY(result.y + scrollOffset);
        } else if ((region & 1) != 0) {
            result.setY(result.y - scrollOffset);
        }
        if ((region & 0x10) != 0) {
            result.setX(result.x + scrollOffset);
        } else if ((region & 8) != 0) {
            result.setX(result.x - scrollOffset);
        }
        return result;
    }

    public String toString() {
        return "ViewportAutoexposeHelper for: " + String.valueOf(this.owner);
    }
}

