/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.handler;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.filter.FilterTools;

public final class FilterUpdateTask
extends AbstractCommandTask {
    private DDiagram diagram;
    private FilterDescription filter;
    private boolean activate;

    public FilterUpdateTask(DDiagram diagram, FilterDescription filter, boolean activate) {
        this.diagram = diagram;
        this.filter = filter;
        this.activate = activate;
    }

    public void execute() {
        NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)5);
        if (this.activate) {
            this.handleActivation();
        } else {
            this.diagram.getActivatedFilters().remove((Object)this.filter);
            ConcernService.resetCurrentConcern((DDiagram)this.diagram);
        }
    }

    public String getLabel() {
        return Messages.ChangeFilterActivation_label;
    }

    private boolean handleVariableInit(CompositeFilterDescription composite, DSemanticDiagram vp) throws InterruptedException {
        boolean containsVariableFilters = false;
        for (Filter objFilter : composite.getFilters()) {
            if (!(objFilter instanceof VariableFilter)) continue;
            VariableFilter theFilter = (VariableFilter)objFilter;
            FilterTools.askForFilterValues(vp, theFilter);
            containsVariableFilters = true;
        }
        return containsVariableFilters;
    }

    private void handleActivation() {
        ConcernDescription oldConcern = null;
        boolean containsVariableFilters = false;
        EList activatedFilters = this.diagram.getActivatedFilters();
        ArrayList activatedFiltersCopy = new ArrayList(activatedFilters);
        if (this.diagram.getCurrentConcern() != null) {
            oldConcern = this.diagram.getCurrentConcern();
            ConcernService.resetCurrentConcern((DDiagram)this.diagram);
        }
        try {
            if (this.filter instanceof CompositeFilterDescription && this.diagram instanceof DSemanticDiagram) {
                containsVariableFilters = this.handleVariableInit((CompositeFilterDescription)this.filter, (DSemanticDiagram)this.diagram);
            }
            if (containsVariableFilters && activatedFiltersCopy.size() > 0) {
                activatedFilters.clear();
            }
            activatedFilters.add(this.filter);
            if (containsVariableFilters && activatedFiltersCopy.size() > 0) {
                activatedFilters.addAll(activatedFiltersCopy);
            }
        }
        catch (InterruptedException interruptedException) {
            ConcernService.setCurrentConcern((DDiagram)this.diagram, (ConcernDescription)oldConcern);
        }
    }
}

