/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.migration;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramInternalQuery;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.osgi.framework.Version;

public class ComputedStyleDescriptionCachePackingFileMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("10.0.0.201502231700");

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        super.postLoad(dAnalysis, loadedVersion);
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DRepresentation dRepresentation : new DViewQuery(dView).getLoadedRepresentations()) {
                    if (!(dRepresentation instanceof DDiagram)) continue;
                    this.packCustomStyleDescriptionRegistry((DDiagram)dRepresentation);
                }
            }
        }
    }

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    private void packCustomStyleDescriptionRegistry(DDiagram dDiagram) {
        ComputedStyleDescriptionRegistry registry = new DDiagramInternalQuery(dDiagram).getComputedStyleDescriptionRegistry(false);
        if (registry != null) {
            EList computedStyleDescriptions = registry.getComputedStyleDescriptions();
            ArrayList<StyleDescription> packedList = new ArrayList<StyleDescription>();
            for (Style style : new DDiagramInternalQuery(dDiagram).getAllStyles()) {
                StyleDescription usedDescription = style.getDescription();
                if (usedDescription == null || !computedStyleDescriptions.contains(usedDescription)) continue;
                StyleDescription equivalent = null;
                Iterator it = packedList.iterator();
                while (it.hasNext() && equivalent == null) {
                    StyleDescription cur = (StyleDescription)it.next();
                    if (!EcoreUtil.equals((EObject)usedDescription, (EObject)cur)) continue;
                    equivalent = cur;
                }
                if (equivalent != null) {
                    style.setDescription(equivalent);
                    continue;
                }
                packedList.add(usedDescription);
            }
            if (!packedList.isEmpty()) {
                computedStyleDescriptions.retainAll(packedList);
            }
        }
    }
}

