/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.EvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.properties.core.internal.SiriusToolServices;

public class SiriusInterpreter
implements org.eclipse.sirius.common.interpreter.api.IInterpreter {
    private IInterpreter interpreter;

    public SiriusInterpreter(Session session) {
        this(session.getInterpreter());
    }

    public SiriusInterpreter(IInterpreter interpreterWithDiagnostic) {
        this.interpreter = Objects.requireNonNull(interpreterWithDiagnostic);
    }

    public org.eclipse.sirius.common.interpreter.api.IEvaluationResult evaluateExpression(Map<String, Object> variables, String expr) {
        EvaluationResult result = EvaluationResult.noEvaluation();
        Object self = variables.get("self");
        if (self instanceof EObject) {
            try {
                try {
                    this.setupInterpreter(variables);
                    IEvaluationResult evaluationResult = this.interpreter.evaluateExpression((EObject)self, expr);
                    result = EvaluationResult.of((Object)evaluationResult.getValue(), (Diagnostic)evaluationResult.getDiagnostic());
                }
                catch (EvaluationException e) {
                    result = EvaluationResult.withError((Diagnostic)BasicDiagnostic.toDiagnostic((Throwable)e));
                    this.tearDownInterpreter(variables);
                }
            }
            finally {
                this.tearDownInterpreter(variables);
            }
        }
        return result;
    }

    private void setupInterpreter(Map<String, Object> variables) {
        this.interpreter.addImport(SiriusToolServices.class.getName());
        this.declareLocals(variables, this.interpreter);
    }

    private void declareLocals(Map<String, Object> variables, IInterpreter i) {
        Set<Map.Entry<String, Object>> entries = variables.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            i.setVariable(entry.getKey(), entry.getValue());
        }
    }

    private void tearDownInterpreter(Map<String, Object> variables) {
        this.unsetLocals(variables, this.interpreter);
    }

    private void unsetLocals(Map<String, Object> variables, IInterpreter i) {
        Set<Map.Entry<String, Object>> entries = variables.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            i.unSetVariable(entry.getKey());
        }
    }
}

