/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.JavaExtension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class VSMNavigation {
    private VSMNavigation() {
    }

    public static boolean isInsideViewExtensionDescription(EObject vsmElement) {
        return new EObjectQuery(vsmElement).getFirstAncestorOfType(PropertiesPackage.Literals.VIEW_EXTENSION_DESCRIPTION).some();
    }

    public static Collection<String> getPageDomainClass(PageDescription page) {
        if (page != null && !Util.isBlank((String)page.getDomainClass())) {
            return Collections.singleton(page.getDomainClass());
        }
        return Collections.singleton(TypeName.EOBJECT_TYPENAME.getCompleteName());
    }

    public static Collection<String> getGroupDomainClass(GroupDescription group) {
        if (group != null && !Util.isBlank((String)group.getDomainClass())) {
            return Collections.singleton(group.getDomainClass());
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PageDescription page : VSMNavigation.findReferencingPages(group)) {
            result.addAll(VSMNavigation.getPageDomainClass(page));
        }
        return result;
    }

    public static Option<Collection<String>> getDomainClassFromContainingGroup(EObject vsmElement) {
        Option result = Options.newNone();
        GroupDescription group = VSMNavigation.findClosestGroupDescription(vsmElement);
        if (group != null) {
            result = Options.newSome(VSMNavigation.getGroupDomainClass(group));
        }
        return result;
    }

    public static Collection<RepresentationDescription> getRepresentationDescriptionsInVSM(EObject vsmElement) {
        ArrayList<RepresentationDescription> result = new ArrayList<RepresentationDescription>();
        Option<EObject> answer = VSMNavigation.getVSMRoot(vsmElement);
        if (answer.some()) {
            Group group = (Group)answer.get();
            for (Viewpoint viewpoint : group.getOwnedViewpoints()) {
                result.addAll((Collection<RepresentationDescription>)viewpoint.getOwnedRepresentations());
            }
        }
        return result;
    }

    public static Collection<String> getJavaExtensionsInVSM(EObject vsmElement) {
        ArrayList<String> result = new ArrayList<String>();
        Option<EObject> answer = VSMNavigation.getVSMRoot(vsmElement);
        if (answer.some()) {
            Group group = (Group)answer.get();
            for (Viewpoint vp : group.getOwnedViewpoints()) {
                for (JavaExtension dep : vp.getOwnedJavaExtensions()) {
                    if (StringUtil.isEmpty((String)dep.getQualifiedClassName())) continue;
                    result.add(dep.getQualifiedClassName());
                }
            }
        }
        return result;
    }

    private static Option<EObject> getVSMRoot(EObject vsmElement) {
        return new EObjectQuery(vsmElement).getFirstAncestorOfType(DescriptionPackage.Literals.GROUP);
    }

    public static Set<PageDescription> findReferencingPages(GroupDescription group) {
        EObject container = group.eContainer();
        if (container instanceof ViewExtensionDescription) {
            ViewExtensionDescription ved = (ViewExtensionDescription)container;
            LinkedHashSet<PageDescription> result = new LinkedHashSet<PageDescription>();
            for (Category category : ved.getCategories()) {
                for (PageDescription page : category.getPages()) {
                    if (!page.getGroups().contains((Object)group)) continue;
                    result.add(page);
                }
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static GroupDescription findClosestGroupDescription(EObject vsmElement) {
        if (vsmElement instanceof GroupDescription) {
            return (GroupDescription)vsmElement;
        }
        Option answer = new EObjectQuery(vsmElement).getFirstAncestorOfType(PropertiesPackage.Literals.GROUP_DESCRIPTION);
        return answer.some() ? (GroupDescription)answer.get() : null;
    }
}

