/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.SidewaysIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public final class SidewaysPrint
implements Print {
    private final Print target;
    private final int angle;

    public SidewaysPrint(Print target) {
        this(target, 90);
    }

    public SidewaysPrint(Print target, int angle) {
        Util.notNull(target);
        this.target = target;
        this.angle = SidewaysPrint.checkAngle(angle);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.angle;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SidewaysPrint other = (SidewaysPrint)obj;
        if (this.angle != other.angle) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    private static int checkAngle(int angle) {
        if (Math.abs(angle) % 90 != 0) {
            PaperClips.error(5, "Angle must be a multiple of 90 degrees");
        }
        if (angle < 0) {
            angle = 360 - -angle % 360;
        }
        if (angle >= 360) {
            angle %= 360;
        }
        return angle;
    }

    public Print getTarget() {
        return this.target;
    }

    public int getAngle() {
        return this.angle;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        if (this.angle == 0) {
            return this.target.iterator(device, gc);
        }
        return new SidewaysIterator(this.target, this.angle, device, gc);
    }
}

