/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.description;

import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContextUtils;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;

public final class MultiLanguagesValidator {
    private IInterpreter currentInterpreter;
    private IInterpreterContext currentContext;

    public ValidationResult validateExpression(IInterpreterContext context, String expression) {
        IInterpreter interpreter = this.provide(context, expression);
        ValidationResult result = new ValidationResult();
        if (interpreter instanceof TypedValidation) {
            result = ((TypedValidation)interpreter).analyzeExpression(context, expression);
        } else if (interpreter != null && interpreter.supportsValidation()) {
            result.addAllStatus(interpreter.validateExpression(context, expression));
        }
        return result;
    }

    private IInterpreter provide(IInterpreterContext context, String expression) {
        if (this.currentContext == null) {
            this.createNewInterpreter(context, expression);
        } else if (!IInterpreterContextUtils.haveSameScopeDefinition((IInterpreterContext)context, (IInterpreterContext)this.currentContext)) {
            if (this.currentInterpreter != null) {
                this.currentInterpreter.dispose();
            }
            this.createNewInterpreter(context, expression);
        }
        return this.currentInterpreter;
    }

    void createNewInterpreter(IInterpreterContext context, String expression) {
        this.currentContext = context;
        this.currentInterpreter = CompoundInterpreter.createGenericInterpreter();
        IInterpreterContextUtils.configureInterpreter((IInterpreter)this.currentInterpreter, (IInterpreterContext)context);
    }

    public void dispose() {
        if (this.currentInterpreter != null) {
            this.currentInterpreter.dispose();
            this.currentInterpreter = null;
        }
        if (this.currentContext != null) {
            this.currentContext = null;
        }
    }

    public static MultiLanguagesValidator getInstance() {
        return MultiLanguagesValidatorHolder.instance;
    }

    private static class MultiLanguagesValidatorHolder {
        private static MultiLanguagesValidator instance = new MultiLanguagesValidator();

        private MultiLanguagesValidatorHolder() {
        }
    }
}

