/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.sirius.business.internal.migration.RepresentationsFileMigrationService;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.osgi.framework.Version;

public class RepresentationsFileResourceHandler
extends BasicResourceHandler {
    private String loadedVersion;

    public RepresentationsFileResourceHandler(String loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public void postLoad(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
        RepresentationsFileMigrationService.getInstance().postLoad(resource, this.loadedVersion);
        super.postLoad(resource, inputStream, options);
    }

    public void preSave(XMLResource resource, OutputStream outputStream, Map<?, ?> options) {
        super.preSave(resource, outputStream, options);
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof DAnalysis) {
            DAnalysis analysis = (DAnalysis)resource.getContents().get(0);
            Version lastMigrationVersion = RepresentationsFileMigrationService.getInstance().getLastMigrationVersion();
            boolean previousDeliver = analysis.eDeliver();
            analysis.eSetDeliver(false);
            analysis.setVersion(lastMigrationVersion.toString());
            analysis.eSetDeliver(previousDeliver);
        }
    }
}

