/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.IdentifiedElement;
import org.osgi.framework.Version;

public class TechnicalUidMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("14.1.0.201808300808");
    private boolean migrationOccured;

    @Override
    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    @Override
    public void postLoad(XMLResource resource, String loadedVersion) {
        if (Version.parseVersion((String)loadedVersion).compareTo(MIGRATION_VERSION) < 0) {
            resource.getAllContents().forEachRemaining(eObject -> {
                if (eObject instanceof IdentifiedElement) {
                    DRepresentation rep;
                    this.migrationOccured = true;
                    IdentifiedElement idElem = (IdentifiedElement)eObject;
                    String xmiid = resource.getID(eObject);
                    idElem.setUid(xmiid);
                    if (eObject instanceof DRepresentationDescriptor && (rep = ((DRepresentationDescriptor)eObject).getRepresentation()) != null) {
                        rep.setUid(resource.getID((EObject)rep));
                        ((DRepresentationDescriptor)eObject).updateRepresentation(rep);
                    }
                }
            });
            if (this.migrationOccured) {
                SiriusPlugin.getDefault().info(MessageFormat.format(Messages.TechnicalUidMigrationParticipant_message, resource.getURI().toPlatformString(true)), null);
                this.migrationOccured = false;
            }
        }
        super.postLoad(resource, loadedVersion);
    }
}

