/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.danalysis.DRepresentationLocationRule;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class DRepLocationRuleForLocalResource
implements DRepresentationLocationRule {
    @Override
    public boolean providesURI(DRepresentation representation, Resource dViewResource) {
        return !new URIQuery(dViewResource.getURI()).isCDOURI();
    }

    @Override
    public URI getResourceURI(DRepresentation representation, Resource airdResource) {
        URI repResourceURI = null;
        repResourceURI = Boolean.getBoolean("createLocalRepresentationInSeparateResource") ? this.getDedicatedRepResourceURI(representation, airdResource) : airdResource.getURI();
        return repResourceURI;
    }

    protected URI getDedicatedRepResourceURI(DRepresentation representation, Resource airdResource) {
        RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
        Object repSegmentName = description.getName();
        String suffix = representation.getUid();
        repSegmentName = (String)repSegmentName + "_" + suffix;
        repSegmentName = URI.encodeSegment((String)repSegmentName, (boolean)true);
        URI airdURI = airdResource.getURI();
        ArrayList<Object> srmFileSegments = new ArrayList<Object>(airdURI.segmentsList());
        srmFileSegments.remove(srmFileSegments.size() - 1);
        srmFileSegments.add(".representations");
        srmFileSegments.add((String)repSegmentName + ".srm");
        return URI.createHierarchicalURI((String)airdURI.scheme(), (String)airdURI.authority(), (String)airdURI.device(), (String[])srmFileSegments.toArray(new String[srmFileSegments.size()]), (String)airdURI.query(), (String)airdURI.fragment());
    }

    protected boolean existsResource(URI repUri, ResourceSet resourceSet) {
        return resourceSet.getURIConverter().exists(repUri, null);
    }

    @Override
    public Boolean isARepresentationFileExtension(String fileExtension) {
        return "srm".equals(fileExtension);
    }
}

