/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.barcharts;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesData;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;

public class BarChart
extends ScrollableChart {
    private static final int LENGTH_HINT_DATA_POINTS = 5000;

    public BarChart() {
    }

    public BarChart(Composite parent, int style) {
        super(parent, style);
    }

    public void addSeriesData(List<IBarSeriesData> barSeriesDataList) {
        this.addSeriesData(barSeriesDataList, Integer.MAX_VALUE);
    }

    public void addSeriesData(List<IBarSeriesData> barSeriesDataList, int compressToLength) {
        if (barSeriesDataList != null && barSeriesDataList.size() > 0) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (IBarSeriesData barSeriesData : barSeriesDataList) {
                try {
                    ISeriesData seriesData = barSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, compressToLength);
                    IBarSeriesSettings barSeriesSettings = barSeriesData.getSettings();
                    barSeriesSettings.getSeriesSettingsHighlight();
                    IBarSeries barSeries = (IBarSeries)this.createSeries(optimizedSeriesData, barSeriesSettings);
                    baseChart.applySeriesSettings((ISeries<?>)barSeries, barSeriesSettings);
                    if (this.isLargeDataSet(optimizedSeriesData.getXSeries(), optimizedSeriesData.getYSeries(), 5000)) {
                        barSeries.setBarWidthStyle(IBarSeries.BarWidthStyle.STRETCHED);
                        continue;
                    }
                    barSeries.setBarWidthStyle(barSeriesSettings.getBarWidthStyle());
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

