/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.charts;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class SelectionRectangle {
    private Point startPoint;
    private Point endPoint;

    public void setStartPoint(int x, int y) {
        this.startPoint = new Point(x, y);
    }

    public void setEndPoint(int x, int y) {
        this.endPoint = new Point(x, y);
    }

    public Point getHorizontalRange() {
        if (this.startPoint == null || this.endPoint == null) {
            return null;
        }
        return new Point(this.startPoint.x, this.endPoint.x);
    }

    public Point getVerticalRange() {
        if (this.startPoint == null || this.endPoint == null) {
            return null;
        }
        return new Point(this.startPoint.y, this.endPoint.y);
    }

    public boolean isDisposed() {
        return this.startPoint == null;
    }

    public void dispose() {
        this.startPoint = null;
        this.endPoint = null;
    }

    public void draw(GC gc) {
        if (this.startPoint == null || this.endPoint == null) {
            return;
        }
        int minX = Math.min(this.startPoint.x, this.endPoint.x);
        int maxX = Math.max(this.startPoint.x, this.endPoint.x);
        int minY = Math.min(this.startPoint.y, this.endPoint.y);
        int maxY = Math.max(this.startPoint.y, this.endPoint.y);
        gc.drawRectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

