/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class MouseWheelEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getEvent() {
        return 2;
    }

    @Override
    public int getButton() {
        return 4;
    }

    @Override
    public int getStateMask() {
        return 0;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        this.runZoomAction(baseChart, event);
        this.postValidateZoom(baseChart);
        baseChart.fireUpdateCustomRangeSelectionHandlers(event);
        baseChart.redraw();
    }

    private void runZoomAction(BaseChart baseChart, Event event) {
        RangeRestriction rangeRestriction = baseChart.getRangeRestriction();
        IAxisSet axisSet = baseChart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        IAxis yAxis = axisSet.getYAxis(0);
        if (baseChart.isZoomXY(rangeRestriction)) {
            baseChart.zoomX(xAxis, event);
            baseChart.zoomY(yAxis, event);
        } else if (rangeRestriction.isRestrictZoomX()) {
            baseChart.zoomX(xAxis, event);
        } else if (rangeRestriction.isRestrictZoomY()) {
            baseChart.zoomY(yAxis, event);
        }
    }

    private void postValidateZoom(BaseChart baseChart) {
        RangeRestriction rangeRestriction = baseChart.getRangeRestriction();
        IAxisSet axisSet = baseChart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        IAxis yAxis = axisSet.getYAxis(0);
        if (rangeRestriction.isRestrictFrame()) {
            Range rangeX = xAxis.getRange();
            Range rangeY = yAxis.getRange();
            baseChart.setRange(xAxis, rangeX.lower, rangeX.upper, true);
            baseChart.setRange(yAxis, rangeY.lower, rangeY.upper, true);
        } else {
            baseChart.adjustSecondaryXAxes();
            baseChart.adjustSecondaryYAxes();
        }
    }
}

