/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.utils;

public final class ConnectStateHelper {
    public static final String UNKNOWN = "unknown";
    public static final String DISCONNECTED = "disconnected";
    public static final String DISCONNECTING = "disconnecting";
    public static final String DISCONNECT_SCHEDULED = "disconnect_scheduled";
    public static final String CONNECTED = "connected";
    public static final String CONNECTING = "connecting";
    public static final String CONNECT_SCHEDULED = "connect_scheduled";
    public static final String CONNECTION_LOST = "connection_lost";
    public static final String CONNECTION_RECOVERING = "connection_recovering";
    public static final String DISCONNECT = "disconnect";
    public static final String CONNECT = "connect";

    public static final int getConnectState(String state) {
        if (DISCONNECTED.equalsIgnoreCase(state)) {
            return 1;
        }
        if (DISCONNECTING.equalsIgnoreCase(state)) {
            return -2;
        }
        if (DISCONNECT_SCHEDULED.equalsIgnoreCase(state)) {
            return -1;
        }
        if (CONNECTED.equalsIgnoreCase(state)) {
            return 11;
        }
        if (CONNECTING.equalsIgnoreCase(state)) {
            return -12;
        }
        if (CONNECT_SCHEDULED.equalsIgnoreCase(state)) {
            return -11;
        }
        if (CONNECTION_LOST.equalsIgnoreCase(state)) {
            return 21;
        }
        if (CONNECTION_RECOVERING.equalsIgnoreCase(state)) {
            return -21;
        }
        if (CONNECT.equalsIgnoreCase(state)) {
            return 11;
        }
        if (DISCONNECT.equalsIgnoreCase(state)) {
            return 1;
        }
        return 0;
    }

    public static final String getConnectState(int state) {
        switch (state) {
            case 1: {
                return DISCONNECTED;
            }
            case -2: {
                return DISCONNECTING;
            }
            case -1: {
                return DISCONNECT_SCHEDULED;
            }
            case 11: {
                return CONNECTED;
            }
            case -12: {
                return CONNECTING;
            }
            case -11: {
                return CONNECT_SCHEDULED;
            }
            case 21: {
                return CONNECTION_LOST;
            }
            case -21: {
                return CONNECTION_RECOVERING;
            }
        }
        return UNKNOWN;
    }

    public static final int getConnectAction(String action) {
        if (CONNECT.equalsIgnoreCase(action)) {
            return 11;
        }
        if (DISCONNECT.equalsIgnoreCase(action)) {
            return 1;
        }
        if (CONNECTION_LOST.equalsIgnoreCase(action)) {
            return 21;
        }
        if (CONNECTION_RECOVERING.equalsIgnoreCase(action)) {
            return -21;
        }
        return 0;
    }

    public static final String getConnectAction(int action) {
        switch (action) {
            case 11: {
                return CONNECT;
            }
            case 1: {
                return DISCONNECT;
            }
            case 21: {
                return CONNECTION_LOST;
            }
            case -21: {
                return CONNECTION_RECOVERING;
            }
        }
        return UNKNOWN;
    }
}

