/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.concurrent.MonitorTask;
import org.eclipse.tcf.te.tcf.core.nls.Messages;

public class CallbackMonitor {
    private static final long DEFAULT_TIMEOUT = 60000L;
    private ICallback callback;
    private Map<Object, IStatus> locks;

    public CallbackMonitor(ICallback callback) {
        this(callback, 60000L);
    }

    public CallbackMonitor(ICallback callback, long timeout) {
        Assert.isNotNull((Object)callback);
        this.callback = callback;
        this.locks = Collections.synchronizedMap(new HashMap());
        if (timeout > 0L) {
            new Timer().schedule((TimerTask)new MonitorTask(callback, timeout), timeout, timeout);
        }
    }

    public CallbackMonitor(ICallback callback, Object ... keys) {
        this(callback, 60000L, keys);
    }

    public CallbackMonitor(ICallback callback, long timeout, Object ... keys) {
        Assert.isNotNull((Object)callback);
        this.callback = callback;
        this.locks = Collections.synchronizedMap(new HashMap());
        this.lock(keys);
        if (timeout > 0L) {
            new Timer().schedule((TimerTask)new MonitorTask(callback, timeout), timeout, timeout);
        }
    }

    public void lock(Object ... keys) {
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Assert.isNotNull((Object)key);
            this.locks.put(key, null);
            ++n2;
        }
    }

    public void lock(Object key) {
        Assert.isNotNull((Object)key);
        this.locks.put(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object key, IStatus status) {
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)status);
        this.locks.put(key, status);
        IStatus current = this.getCurrentStatus();
        ICallback iCallback = this.callback;
        synchronized (iCallback) {
            if (current != null && !this.callback.isDone()) {
                this.callback.done((Object)this, current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized IStatus getCurrentStatus() {
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        Map<Object, IStatus> map = this.locks;
        synchronized (map) {
            Iterator<Map.Entry<Object, IStatus>> iterator = this.locks.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, IStatus> entry = iterator.next();
                IStatus status = entry.getValue();
                if (status == null) {
                    return null;
                }
                list.add(status);
            }
        }
        IStatus[] children = list.toArray(new IStatus[list.size()]);
        return new MultiStatus(CoreBundleActivator.getUniqueIdentifier(), 0, children, Messages.CallbackMonitor_AllTasksFinished, null);
    }
}

