/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.utils;

import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessStateChangeEvent;

public class TERunProcess
extends PlatformObject
implements IProcess,
IEventListener {
    private ProcessLauncher prLauncher;
    private String prName;
    private boolean terminated;
    private ILaunch launch;
    private IProcesses.ProcessContext context;
    private int exitValue;

    public TERunProcess(ILaunch launch, String remoteExePath, String arguments, String label, IPeer peer, SubProgressMonitor monitor) {
        this(launch, remoteExePath, arguments, null, label, peer, monitor);
    }

    public TERunProcess(ILaunch launch, String remoteExePath, String arguments, Map<String, String> env, String label, IPeer peer, SubProgressMonitor monitor) {
        this.launch = launch;
        this.prName = remoteExePath;
        this.terminated = false;
        launch.addProcess((IProcess)this);
        EventManager.getInstance().addEventListener((IEventListener)this, ProcessStateChangeEvent.class);
        try {
            this.prLauncher = TEHelper.launchCmdWithEnv(peer, null, remoteExePath, arguments, env, null, monitor, (ICallback)new Callback());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getUniqueIdentifier(), "Error launching remote process: " + this.prName, (Throwable)e));
            String reason = e.getMessage();
            if (reason == null) {
                reason = "Unknown Reason";
            }
            this.prName = String.valueOf(this.prName) + " (Failed to start: " + reason + ')';
        }
        this.fireCreationEvent();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return targets[i];
                }
                ++i;
            }
            return null;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return this.getLaunch().getLaunchConfiguration();
        }
        return super.getAdapter(adapter);
    }

    public boolean canTerminate() {
        return this.prLauncher != null && !this.terminated;
    }

    public boolean isTerminated() {
        return this.prLauncher == null || this.terminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            this.prLauncher.terminate();
        }
    }

    public String getLabel() {
        return this.prName;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.exitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.RuntimeProcess_Exit_value_not_available_until_process_terminates__1, null));
    }

    public void eventFired(EventObject event) {
        if (event instanceof ProcessStateChangeEvent) {
            ProcessStateChangeEvent pscEvent = (ProcessStateChangeEvent)event;
            if (pscEvent.getEventId().equals("created")) {
                if (pscEvent.getSource() instanceof IProcesses.ProcessContext && this.prLauncher != null && this.prLauncher.getAdapter(IProcesses.ProcessContext.class) == pscEvent.getSource()) {
                    this.context = (IProcesses.ProcessContext)pscEvent.getSource();
                }
            } else if (pscEvent.getEventId().equals("terminated") && pscEvent.getSource() instanceof IProcesses.ProcessContext && ((IProcesses.ProcessContext)pscEvent.getSource()).getID().equals(this.context.getID())) {
                this.exitValue = pscEvent.getExitCode();
                this.terminated = true;
                this.fireTerminateEvent();
            }
        }
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }
}

