/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tcf.te.core.utils.Ancestor;
import org.eclipse.tcf.te.ui.interfaces.ISchedulableEvent;

public class CommonViewerListener
extends Ancestor<Object>
implements PropertyChangeListener,
IPropertyChangeListener {
    private static Timer viewerTimer = new Timer("Viewer_Refresher", true);
    private static final long INTERVAL = 333L;
    private static final long MAX_DELAY = 1000L;
    private static final Object NULL = new Object();
    private TreeViewer viewer;
    private List<EventObject> queue;
    private TimerTask task;
    ITreeContentProvider contentProvider;
    long lastRun;

    public CommonViewerListener(TreeViewer viewer, ITreeContentProvider contentProvider) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        this.contentProvider = contentProvider;
        this.task = new TimerTask(){

            @Override
            public void run() {
                CommonViewerListener.this.handleEvent(true);
            }
        };
        viewerTimer.schedule(this.task, 333L, 333L);
        this.queue = Collections.synchronizedList(new ArrayList());
    }

    protected Object getParent(Object element) {
        return this.contentProvider.getParent(element);
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent event) {
        this.processEvent(event);
    }

    private void processEvent(EventObject event) {
        if (!(event instanceof ISchedulableEvent) || ((ISchedulableEvent)((Object)event)).isApplicable(this.viewer)) {
            this.queue.add(event);
            if (event instanceof ISchedulableEvent) {
                ((ISchedulableEvent)((Object)event)).eventQueued();
            }
            viewerTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CommonViewerListener.this.handleEvent(false);
                }
            }, 0L);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.processEvent((EventObject)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] emptyQueue() {
        List<EventObject> list = this.queue;
        synchronized (list) {
            Iterator<EventObject> iterator = this.queue.iterator();
            ArrayList<Object> objects = new ArrayList<Object>();
            while (iterator.hasNext()) {
                EventObject event = iterator.next();
                if (event instanceof ISchedulableEvent && !((ISchedulableEvent)((Object)event)).isSchedulable()) continue;
                objects.add(event.getSource());
                iterator.remove();
            }
            return objects.toArray();
        }
    }

    synchronized boolean checkReady(boolean scheduled) {
        if (scheduled || System.currentTimeMillis() - this.lastRun > 1000L) {
            this.lastRun = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    void handleEvent(boolean scheduled) {
        Object[] objects;
        if (this.checkReady(scheduled) && (objects = this.emptyQueue()).length > 0) {
            List<Object> list = this.mergeObjects(objects);
            Object object = this.getRefreshRoot(list);
            this.processObject(object);
        }
    }

    private Object getRefreshRoot(List<Object> objects) {
        if (objects.isEmpty()) {
            return NULL;
        }
        if (objects.size() == 1) {
            Object object = objects.get(0);
            if (this.contentProvider.getParent(object) == null) {
                return NULL;
            }
            return object;
        }
        Object object = this.getAncestor(objects);
        if (object == null) {
            return NULL;
        }
        return object;
    }

    private List<Object> mergeObjects(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == NULL) {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(NULL);
                return result;
            }
            ++n2;
        }
        List<Object> list = Arrays.asList(objects);
        HashSet<Object> set = new HashSet<Object>(list);
        objects = set.toArray();
        list = Arrays.asList(objects);
        return this.getAncestors(list);
    }

    void processObject(final Object object) {
        Assert.isNotNull((Object)object);
        Tree tree = this.viewer.getTree();
        if (!tree.isDisposed()) {
            Display display = tree.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                if (object != NULL) {
                    this.viewer.refresh(object);
                } else {
                    this.viewer.refresh();
                }
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CommonViewerListener.this.processObject(object);
                    }
                });
            }
        }
    }

    public void cancel() {
        this.task.cancel();
    }
}

