/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tcf.te.ui.trees.AbstractContentContribution;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.ContentDescriptor;

public class TreeViewerDelegatingContentProvider
implements ITreeContentProvider {
    private final AbstractTreeControl parentTreeControl;
    private final ITreeContentProvider contentProvider;

    public TreeViewerDelegatingContentProvider(AbstractTreeControl parentTreeControl, ITreeContentProvider contentProvider) {
        Assert.isNotNull((Object)((Object)parentTreeControl));
        this.parentTreeControl = parentTreeControl;
        Assert.isNotNull((Object)contentProvider);
        this.contentProvider = contentProvider;
    }

    public Object[] getElements(Object inputElement) {
        ContentDescriptor[] descriptors;
        boolean nonNullElements = false;
        ArrayList<Object> elements = new ArrayList<Object>();
        Object[] candidates = this.contentProvider.getElements(inputElement);
        if (candidates != null) {
            nonNullElements = true;
            elements.addAll(Arrays.asList(candidates));
        }
        if ((descriptors = this.parentTreeControl.getContentDescriptors()) != null) {
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentProvider delegate;
                ContentDescriptor descriptor = contentDescriptorArray[n2];
                AbstractContentContribution contribution = descriptor.getContentContribution();
                if (contribution != null && (delegate = contribution.getContentProvider()) != null && (candidates = delegate.getElements(inputElement)) != null) {
                    nonNullElements = true;
                    elements.addAll(Arrays.asList(candidates));
                }
                ++n2;
            }
        }
        return nonNullElements ? elements.toArray() : null;
    }

    public Object[] getChildren(Object parentElement) {
        ContentDescriptor[] descriptors;
        boolean nonNullChildren = false;
        ArrayList<Object> children = new ArrayList<Object>();
        Object[] candidates = this.contentProvider.getChildren(parentElement);
        if (candidates != null) {
            nonNullChildren = true;
            children.addAll(Arrays.asList(candidates));
        }
        if ((descriptors = this.parentTreeControl.getContentDescriptors()) != null) {
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentProvider delegate;
                ContentDescriptor descriptor = contentDescriptorArray[n2];
                AbstractContentContribution contribution = descriptor.getContentContribution();
                if (contribution != null && (delegate = contribution.getContentProvider()) != null && (candidates = delegate.getChildren(parentElement)) != null) {
                    nonNullChildren = true;
                    children.addAll(Arrays.asList(candidates));
                }
                ++n2;
            }
        }
        return nonNullChildren ? children.toArray() : null;
    }

    public Object getParent(Object element) {
        ContentDescriptor[] descriptors;
        Object parent = this.contentProvider.getParent(element);
        if (parent == null && (descriptors = this.parentTreeControl.getContentDescriptors()) != null) {
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentProvider delegate;
                ContentDescriptor descriptor = contentDescriptorArray[n2];
                AbstractContentContribution contribution = descriptor.getContentContribution();
                if (contribution != null && contribution.isElementHandled(element) && (delegate = contribution.getContentProvider()) != null) {
                    parent = delegate.getParent(element);
                    break;
                }
                ++n2;
            }
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        ContentDescriptor[] descriptors;
        boolean hasChildren = this.contentProvider.hasChildren(element);
        if (!hasChildren && (descriptors = this.parentTreeControl.getContentDescriptors()) != null) {
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentProvider delegate;
                ContentDescriptor descriptor = contentDescriptorArray[n2];
                AbstractContentContribution contribution = descriptor.getContentContribution();
                if (contribution != null && contribution.isElementHandled(element) && (delegate = contribution.getContentProvider()) != null) {
                    hasChildren = delegate.hasChildren(element);
                    break;
                }
                ++n2;
            }
        }
        return hasChildren;
    }

    public void dispose() {
        this.contentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.contentProvider.inputChanged(viewer, oldInput, newInput);
        ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
        if (descriptors != null) {
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeContentProvider delegate;
                ContentDescriptor descriptor = contentDescriptorArray[n2];
                AbstractContentContribution contribution = descriptor.getContentContribution();
                if (contribution != null && (delegate = contribution.getContentProvider()) != null) {
                    delegate.inputChanged(viewer, oldInput, newInput);
                }
                ++n2;
            }
        }
    }
}

