/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractFormsWizardPage
extends AbstractValidatingWizardPage {
    private CustomFormToolkit toolkit = null;
    ManagedForm mform = null;

    public AbstractFormsWizardPage(String pageName) {
        super(pageName);
    }

    public AbstractFormsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
            this.mform = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected CustomFormToolkit createFormToolkit(Display display) {
        Assert.isNotNull((Object)display);
        return new CustomFormToolkit(new FormToolkit(display));
    }

    public final CustomFormToolkit getFormToolkit() {
        return this.toolkit;
    }

    public final IManagedForm getManagedForm() {
        return this.mform;
    }

    public void createControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.toolkit = this.createFormToolkit(parent.getDisplay());
        Assert.isNotNull((Object)this.toolkit);
        ScrolledForm form = this.toolkit.createScrolledForm(parent, null, true);
        Assert.isNotNull((Object)form);
        this.setControl((Control)form);
        this.mform = new WizardPageForm(this, form);
        boolean changed = this.setValidationInProgress(true);
        this.createFormContent((IManagedForm)this.mform);
        if (changed) {
            this.setValidationInProgress(false);
        }
        Dialog.applyDialogFont((Control)form);
        this.validate();
    }

    protected void createFormContent(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        this.configureManagedForm(managedForm);
        this.doCreateFormContent(managedForm.getForm().getBody(), this.toolkit);
        managedForm.reflow(true);
    }

    protected void configureManagedForm(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)false, (int)1));
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.getContextHelpId());
        }
    }

    protected abstract void doCreateFormContent(Composite var1, CustomFormToolkit var2);

    private static class WizardPageForm
    extends ManagedForm {
        public WizardPageForm(AbstractFormsWizardPage parentPage, ScrolledForm form) {
            super(parentPage.getFormToolkit().getFormToolkit(), form);
            this.setContainer((Object)parentPage);
        }

        public AbstractFormsWizardPage getParentPage() {
            return (AbstractFormsWizardPage)((Object)this.getContainer());
        }

        public void dirtyStateChanged() {
            this.getParentPage().validate();
        }

        public void staleStateChanged() {
            this.getParentPage().validate();
        }
    }
}

