/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.core.DefaultFileModificationValidator;
import org.eclipse.team.internal.core.Messages;

public class FileModificationValidatorManager
extends FileModificationValidator {
    private FileModificationValidator defaultValidator;

    public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
        ArrayList<IStatus> returnStati = new ArrayList<IStatus>();
        HashMap providersToFiles = new HashMap(files.length);
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            RepositoryProvider provider = RepositoryProvider.getProvider(file.getProject());
            if (!providersToFiles.containsKey(provider)) {
                providersToFiles.put(provider, new ArrayList());
            }
            ((List)providersToFiles.get(provider)).add(file);
            ++n2;
        }
        Iterator providersIterator = providersToFiles.keySet().iterator();
        boolean allOK = true;
        while (providersIterator.hasNext()) {
            IStatus status;
            FileModificationValidator v;
            RepositoryProvider provider = (RepositoryProvider)providersIterator.next();
            List filesList = (List)providersToFiles.get(provider);
            IFile[] filesArray = filesList.toArray(new IFile[filesList.size()]);
            FileModificationValidator validator = this.getDefaultValidator();
            if (provider != null && (v = provider.getFileModificationValidator2()) != null) {
                validator = v;
            }
            if (!(status = validator.validateEdit(filesArray, context)).isOK()) {
                allOK = false;
            }
            returnStati.add(status);
        }
        if (returnStati.size() == 1) {
            return (IStatus)returnStati.get(0);
        }
        return new MultiStatus("org.eclipse.team.core", 0, returnStati.toArray(new IStatus[returnStati.size()]), allOK ? Messages.ok : Messages.FileModificationValidator_editFailed, null);
    }

    public IStatus validateSave(IFile file) {
        FileModificationValidator v;
        RepositoryProvider provider = RepositoryProvider.getProvider(file.getProject());
        FileModificationValidator validator = this.getDefaultValidator();
        if (provider != null && (v = provider.getFileModificationValidator2()) != null) {
            validator = v;
        }
        return validator.validateSave(file);
    }

    private synchronized FileModificationValidator getDefaultValidator() {
        if (this.defaultValidator == null) {
            this.defaultValidator = new DefaultFileModificationValidator();
        }
        return this.defaultValidator;
    }
}

