/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.wizards.ConfigureProjectWizard;

public class ConfigureProjectAction
extends TeamAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(monitor -> {
            try {
                if (!this.isEnabled()) {
                    return;
                }
                IProject[] projects = this.getSelectedProjects();
                ConfigureProjectWizard.shareProjects(this.getShell(), projects);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }, TeamUIMessages.ConfigureProjectAction_configureProject, 2);
    }

    public boolean isEnabled() {
        IProject[] selectedProjects;
        IProject[] iProjectArray = selectedProjects = this.getSelectedProjects();
        int n = selectedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.isAccessible()) {
                return false;
            }
            if (RepositoryProvider.isShared((IProject)project)) {
                return false;
            }
            ++n2;
        }
        return selectedProjects.length > 0;
    }
}

