/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeChangeListener;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ShowModelProviderAction;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelOperation;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class ModelSelectionDropDownAction
extends Action
implements ISynchronizationScopeChangeListener {
    private final ISynchronizePageConfiguration configuration;
    private MenuManager menuManager;
    private final Action showAllAction;
    private final IPropertyChangeListener listener;
    private final MenuCreator menuCreator;
    private final Action showAllFlatAction;

    public ModelSelectionDropDownAction(ISynchronizePageConfiguration configuration) {
        Utils.initAction((IAction)this, "action.pickModels.");
        this.configuration = configuration;
        this.listener = event -> {
            if (event.getProperty() == "org.eclipse.team.ui.activeModelProvider") {
                this.update();
            }
            if (event.getProperty().equals("org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS")) {
                this.rebuildMenu();
            }
        };
        this.configuration.addPropertyChangeListener(this.listener);
        TeamUI.getTeamContentProviderManager().addPropertyChangeListener(this.listener);
        this.getSynchronizationContext().getScope().addScopeChangeListener((ISynchronizationScopeChangeListener)this);
        this.showAllAction = new Action(TeamUIMessages.ModelSelectionDropDownAction_0, 8){

            public void run() {
                ModelSelectionDropDownAction.this.configuration.setProperty("org.eclipse.team.ui.activeModelProvider", "org.eclipse.team.ui.activeModelProvider");
            }
        };
        this.showAllFlatAction = new Action(TeamUIMessages.ModelSelectionDropDownAction_2, 2){

            public void run() {
                boolean checked = ModelSelectionDropDownAction.this.showAllFlatAction.isChecked();
                ModelSelectionDropDownAction.this.configuration.setProperty("org.eclipse.team.ui.pageLayout", checked ? "org.eclipse.team.ui.flatLayout" : "org.eclipse.team.ui.treeLayout");
            }
        };
        this.showAllFlatAction.setImageDescriptor(TeamImages.getImageDescriptor("elcl16/flatLayout.png"));
        this.menuCreator = new MenuCreator();
        this.setMenuCreator(this.menuCreator);
        this.update();
    }

    private ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    public void dispose() {
        if (this.menuCreator != null) {
            this.menuCreator.dispose();
        }
        this.getSynchronizationContext().getScope().removeScopeChangeListener((ISynchronizationScopeChangeListener)this);
        this.configuration.removePropertyChangeListener(this.listener);
        TeamUI.getTeamContentProviderManager().removePropertyChangeListener(this.listener);
    }

    private ModelProvider[] getEnabledModelProviders() {
        HashSet<ModelProvider> result = new HashSet<ModelProvider>();
        ModelProvider[] providers = ((ModelSynchronizeParticipant)this.configuration.getParticipant()).getEnabledModelProviders();
        ModelProvider[] modelProviderArray = providers = ModelOperation.sortByExtension(providers);
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
            if (desc != null && desc.isEnabled()) {
                result.add(provider);
            }
            ++n2;
        }
        return result.toArray(new ModelProvider[result.size()]);
    }

    private void addModelsToMenu(ModelProvider[] modelProviders) {
        String id = this.getActiveProviderId();
        ModelProvider[] modelProviderArray = modelProviders;
        int n = modelProviders.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider = modelProviderArray[n2];
            ShowModelProviderAction action = new ShowModelProviderAction(this.configuration, provider);
            action.setChecked(provider.getDescriptor().getId().equals(id));
            this.menuManager.add((IAction)action);
            ++n2;
        }
    }

    private String getActiveProviderId() {
        String id = (String)this.configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (id == null) {
            id = "org.eclipse.team.ui.activeModelProvider";
        }
        return id;
    }

    private ModelProvider getNextProvider() {
        ModelProvider[] providers = this.getSynchronizationContext().getScope().getModelProviders();
        if (providers.length == 0) {
            return null;
        }
        providers = ModelOperation.sortByExtension(providers);
        String id = this.getActiveProviderId();
        int index = 0;
        if (id != null) {
            int i = 0;
            while (i < providers.length) {
                ModelProvider provider = providers[i];
                if (provider.getDescriptor().getId().equals(id)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index == providers.length) {
                index = 0;
            }
        }
        return providers[index];
    }

    public void update() {
        ModelProvider next = this.getNextProvider();
        if (next == null) {
            return;
        }
        String text = NLS.bind((String)TeamUIMessages.ModelSelectionDropDownAction_1, (Object)next.getDescriptor().getLabel());
        this.setToolTipText(text);
        this.setText(text);
        if (this.menuManager != null) {
            IContributionItem[] items;
            this.showAllAction.setChecked(this.getActiveProviderId().equals("org.eclipse.team.ui.activeModelProvider"));
            this.showAllFlatAction.setChecked(this.isFlatEnabled());
            IContributionItem[] iContributionItemArray = items = this.menuManager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ActionContributionItem aci;
                IAction a;
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (a = (aci = (ActionContributionItem)item).getAction()) instanceof ShowModelProviderAction) {
                    ShowModelProviderAction action = (ShowModelProviderAction)a;
                    action.setChecked(action.getProviderId().equals(this.getActiveProviderId()));
                }
                ++n2;
            }
        }
    }

    private boolean isFlatEnabled() {
        String p = (String)this.configuration.getProperty("org.eclipse.team.ui.pageLayout");
        return p != null && p.equals("org.eclipse.team.ui.flatLayout");
    }

    public void run() {
        ModelProvider next = this.getNextProvider();
        if (next == null) {
            return;
        }
        ShowModelProviderAction action = new ShowModelProviderAction(this.configuration, next);
        action.run();
    }

    public void scopeChanged(ISynchronizationScope scope, ResourceMapping[] newMappings, ResourceTraversal[] newTraversals) {
        if (newMappings.length > 0) {
            this.rebuildMenu();
        }
    }

    private void rebuildMenu() {
        Display display = TeamUIPlugin.getStandardDisplay();
        display.asyncExec(() -> {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
            this.update();
        });
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuCreator() {
        }

        public void dispose() {
            if (ModelSelectionDropDownAction.this.menuManager != null) {
                ModelSelectionDropDownAction.this.menuManager.dispose();
                ModelSelectionDropDownAction.this.menuManager = null;
            }
        }

        public Menu getMenu(Control parent) {
            Menu fMenu = null;
            if (ModelSelectionDropDownAction.this.menuManager == null) {
                ModelSelectionDropDownAction.this.menuManager = new MenuManager();
                fMenu = ModelSelectionDropDownAction.this.menuManager.createContextMenu(parent);
                ModelSelectionDropDownAction.this.menuManager.add((IAction)ModelSelectionDropDownAction.this.showAllAction);
                ModelSelectionDropDownAction.this.showAllAction.setChecked(ModelSelectionDropDownAction.this.getActiveProviderId().equals("org.eclipse.team.ui.activeModelProvider"));
                ModelSelectionDropDownAction.this.showAllFlatAction.setChecked(ModelSelectionDropDownAction.this.isFlatEnabled());
                ModelProvider[] modelProviders = ModelSelectionDropDownAction.this.getEnabledModelProviders();
                if (modelProviders.length > 0) {
                    ModelSelectionDropDownAction.this.menuManager.add((IContributionItem)new Separator());
                }
                ModelSelectionDropDownAction.this.addModelsToMenu(modelProviders);
                ModelSelectionDropDownAction.this.menuManager.add((IContributionItem)new Separator());
                ModelSelectionDropDownAction.this.menuManager.add((IAction)ModelSelectionDropDownAction.this.showAllFlatAction);
                ModelSelectionDropDownAction.this.menuManager.update(true);
            } else {
                fMenu = ModelSelectionDropDownAction.this.menuManager.getMenu();
            }
            return fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

