/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ISynchronizationCompareAdapter;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class SynchronizationCompareAdapter
implements ISynchronizationCompareAdapter {
    @Override
    public ICompareInput asCompareInput(ISynchronizationContext context, Object o) {
        IDiff node;
        IResource resource = Utils.getResource(o);
        if (resource != null && resource.getType() == 1 && (node = context.getDiffTree().getDiff(resource)) != null) {
            return new ResourceDiffCompareInput(node, context);
        }
        return null;
    }

    @Override
    public boolean hasCompareInput(ISynchronizationContext context, Object object) {
        return this.asCompareInput(context, object) != null;
    }

    @Override
    public String getName(ResourceMapping mapping) {
        String label;
        Object object = mapping.getModelObject();
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Adapters.adapt((Object)object, IWorkbenchAdapter.class);
        if (adapter != null && (label = adapter.getLabel(object)) != null) {
            return label;
        }
        IResource resource = Utils.getResource(object);
        if (resource != null) {
            return resource.getName();
        }
        if (object instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)object;
            if (provider.getId().equals("org.eclipse.core.resources.modelProvider")) {
                return TeamUIMessages.SynchronizationCompareAdapter_0;
            }
            return provider.getDescriptor().getLabel();
        }
        return "";
    }

    @Override
    public String getPathString(ResourceMapping mapping) {
        Object object = mapping.getModelObject();
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Adapters.adapt((Object)object, IWorkbenchAdapter.class);
        if (adapter != null) {
            ArrayList<String> segments = new ArrayList<String>();
            Object parent = object;
            do {
                String segment;
                if ((segment = adapter.getLabel(parent)) == null || segment.length() <= 0) continue;
                segments.add(0, segment);
            } while ((parent = adapter.getParent(parent)) != null);
            if (!segments.isEmpty()) {
                IPath path = IPath.EMPTY;
                for (String segment : segments) {
                    path = path.append(segment);
                }
                return path.toString();
            }
        }
        return this.getName(mapping);
    }

    @Override
    public ImageDescriptor getImageDescriptor(ResourceMapping mapping) {
        Object object = mapping.getModelObject();
        ImageDescriptor image = this.getImageDescriptorFromWorkbenchAdapter(object);
        if (image != null) {
            return image;
        }
        IResource resource = Utils.getResource(object);
        if (resource != null && (image = this.getImageDescriptorFromWorkbenchAdapter(resource)) != null) {
            return image;
        }
        if (object instanceof ModelProvider) {
            ModelProvider provider = (ModelProvider)object;
            ITeamContentProviderDescriptor desc = TeamUI.getTeamContentProviderManager().getDescriptor(provider.getId());
            if (desc != null) {
                return desc.getImageDescriptor();
            }
        }
        return null;
    }

    private ImageDescriptor getImageDescriptorFromWorkbenchAdapter(Object object) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)Adapters.adapt((Object)object, IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getImageDescriptor(object);
        }
        return null;
    }

    @Override
    public int getSynchronizationState(ITeamStateProvider provider, ResourceMapping mapping, int stateMask, IProgressMonitor monitor) throws CoreException {
        return -1;
    }
}

