/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.CpuUsageDataProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CpuUsageProviderFactory
implements IDataProviderFactory {
    private static final Predicate<? super ITmfTrace> PREDICATE = t -> TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)t, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage") != null;
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider").setName(Objects.requireNonNull(Messages.CpuUsageDataProvider_title)).setDescription(Objects.requireNonNull(Messages.CpuUsageProviderFactory_DescriptionText)).setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY).build();

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() == 1) {
            return CpuUsageDataProvider.create(trace);
        }
        return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)Objects.requireNonNull(Messages.CpuUsageDataProvider_title), (String)"org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider");
    }

    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        return Iterables.any((Iterable)traces, PREDICATE) ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }
}

