/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponentChangedListener;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlContentProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlLabelProvider;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlRoot;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ControlView
extends ViewPart
implements ITraceControlComponentChangedListener {
    public static final String ID = "org.eclipse.linuxtools.internal.lttng2.ui.views.control";
    private static final String KEY_REMOTE_CONNECTION_NAME = "rc_name_";
    private static final String KEY_REMOTE_PROVIDER = "rc_id_";
    private static final int DEFAULT_EXPAND_LEVEL = 3;
    private TreeViewer fTreeViewer = null;
    private ITraceControlComponent fRoot = null;
    private List<IRemoteConnection> fInitialConnections;

    public ITraceControlComponent getTraceControlRoot() {
        return this.fRoot;
    }

    public void createPartControl(Composite parent) {
        PatternFilter filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                ITraceControlComponent parentElement = (ITraceControlComponent)element;
                while (parentElement != null) {
                    if (super.isLeafMatch(viewer, (Object)parentElement)) {
                        return true;
                    }
                    parentElement = parentElement.getParent();
                }
                return false;
            }
        };
        FilteredTree filteredTree = new FilteredTree(parent, 770, filter, true){

            protected void updateToolbar(boolean visible) {
                super.updateToolbar(visible);
                this.treeViewer.expandToLevel(3);
            }
        };
        this.fTreeViewer = filteredTree.getViewer();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTreeViewer);
        this.fTreeViewer.setContentProvider((IContentProvider)new TraceControlContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TraceControlLabelProvider());
        this.fRoot = new TraceControlRoot();
        this.fRoot.addComponentListener(this);
        if (this.fInitialConnections != null) {
            for (IRemoteConnection rc : this.fInitialConnections) {
                TargetNodeComponent node = new TargetNodeComponent(rc.getName(), this.fRoot, rc);
                this.fRoot.addChild(node);
            }
            this.fInitialConnections = null;
        }
        this.fTreeViewer.setInput((Object)this.fRoot);
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
    }

    public void saveState(IMemento memento) {
        int i = 0;
        ITraceControlComponent[] iTraceControlComponentArray = this.fRoot.getChildren();
        int n = iTraceControlComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITraceControlComponent cmp = iTraceControlComponentArray[n2];
            if (cmp instanceof TargetNodeComponent) {
                IRemoteConnection rc = ((TargetNodeComponent)cmp).getRemoteSystemProxy().getRemoteConnection();
                memento.putString(KEY_REMOTE_PROVIDER + i, rc.getConnectionType().getId());
                memento.putString(KEY_REMOTE_CONNECTION_NAME + i, rc.getName());
                ++i;
            }
            ++n2;
        }
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.fInitialConnections = new ArrayList<IRemoteConnection>();
            int i = 0;
            while (true) {
                String id = memento.getString(KEY_REMOTE_PROVIDER + i);
                String name = memento.getString(KEY_REMOTE_CONNECTION_NAME + i);
                if (id == null || name == null) break;
                IRemoteConnection conn = TmfRemoteConnectionFactory.getRemoteConnection((String)id, (String)name);
                if (conn != null) {
                    this.fInitialConnections.add(conn);
                }
                ++i;
            }
        }
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    @Override
    public void componentAdded(ITraceControlComponent parent, ITraceControlComponent component) {
        this.componentChanged(parent);
    }

    @Override
    public void componentRemoved(ITraceControlComponent parent, ITraceControlComponent component) {
        this.componentChanged(parent);
    }

    @Override
    public void componentChanged(final ITraceControlComponent component) {
        if (this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        UIJob myJob = new UIJob("Refresh"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (ControlView.this.fTreeViewer.getTree().isDisposed()) {
                    return Status.OK_STATUS;
                }
                ControlView.this.fTreeViewer.refresh((Object)component);
                ISelection sel = ControlView.this.fTreeViewer.getSelection();
                ControlView.this.fTreeViewer.setSelection(null);
                ControlView.this.fTreeViewer.setSelection(sel);
                ControlView.this.fTreeViewer.reveal((Object)component);
                return Status.OK_STATUS;
            }
        };
        myJob.setUser(false);
        myJob.setSystem(true);
        myJob.schedule();
    }

    public void setSelection(ITraceControlComponent component) {
        ITraceControlComponent[] components = new ITraceControlComponent[]{component};
        this.setSelection(components);
    }

    public void setSelection(ITraceControlComponent[] components) {
        final StructuredSelection selection = new StructuredSelection((Object[])components);
        UIJob myJob = new UIJob("Select"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ControlView.this.fTreeViewer.setSelection((ISelection)selection);
                return Status.OK_STATUS;
            }
        };
        myJob.setUser(false);
        myJob.schedule();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fTreeViewer);
    }
}

