/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.LttngProfileManager;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ISaveDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SaveHandler
extends BaseControlViewHandler {
    protected List<TraceSessionComponent> fSessions = new ArrayList<TraceSessionComponent>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        this.fLock.lock();
        try {
            final ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>();
            sessions.addAll(this.fSessions);
            final ISaveDialog dialog = TraceControlDialogFactory.getInstance().getSaveDialog();
            if (dialog.open() != 0) {
                return null;
            }
            Job job = new Job(Messages.TraceControl_SaveJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        for (TraceSessionComponent session : sessions) {
                            session.saveSession(null, null, dialog.isForce(), monitor);
                            IRemoteConnection connection = session.getTargetNode().getRemoteSystemProxy().getRemoteConnection();
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                            IRemoteProcessService processService = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
                            IPath path = null;
                            if (processService != null) {
                                String cwd = processService.getWorkingDirectory();
                                path = RemoteServicesUtils.posixPath((String)cwd);
                                path = path.append(".lttng/sessions");
                            }
                            if (path == null) {
                                return Status.CANCEL_STATUS;
                            }
                            IRemoteFileService fileService = (IRemoteFileService)connection.getService(IRemoteFileService.class);
                            if (fileService == null) {
                                return Status.CANCEL_STATUS;
                            }
                            IPath dest = LttngProfileManager.getProfilePath();
                            String profileName = session.getName() + ".lttng";
                            Path destPath = FileSystems.getDefault().getPath(dest.toString(), new String[0]).resolve(profileName);
                            IFileStore destFileStore = EFS.getLocalFileSystem().fromLocalFile(destPath.toFile());
                            SubMonitor childMonitor = subMonitor.newChild(1);
                            IPath remotePath = RemoteServicesUtils.posixPath((String)path.toString()).append(profileName);
                            IFileStore remoteResource = fileService.getResource(remotePath.toString());
                            boolean[] overwrite = new boolean[1];
                            if (destPath.toFile().exists()) {
                                Display.getDefault().syncExec(() -> {
                                    boolean bl = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.TraceControl_ProfileAlreadyExists, (String)NLS.bind((String)Messages.TraceControl_OverwriteQuery, (Object)destPath.getFileName()));
                                });
                                if (!overwrite[0]) continue;
                            }
                            remoteResource.copy(destFileStore, 2, (IProgressMonitor)childMonitor);
                        }
                    }
                    catch (ExecutionException | CoreException e) {
                        return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_SaveFailure, e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        finally {
            this.fLock.unlock();
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ArrayList<TraceSessionComponent> sessions = new ArrayList<TraceSessionComponent>(0);
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceSessionComponent session;
                if (!(element instanceof TraceSessionComponent) || (session = (TraceSessionComponent)element).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                sessions.add(session);
            }
        }
        boolean isEnabled = !sessions.isEmpty();
        this.fLock.lock();
        try {
            this.fSessions = null;
            if (isEnabled) {
                this.fSessions = sessions;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

