/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.statesystem.core.backend.IPartialStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;

public class PartialInMemoryBackend
implements IPartialStateHistoryBackend {
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(PartialInMemoryBackend.class);
    private final @NonNull String fSSID;
    private final NavigableSet<@NonNull ITmfStateInterval> fCurrentIntervals;
    private final long fStartTime;
    public static IntegerRangeCondition fRangeCondition;
    public static TimeRangeCondition fTimeCondition;
    public static boolean fIs2DQuery;
    private volatile long fLatestTime;

    public PartialInMemoryBackend(@NonNull String ssid, long startTime) {
        this.fSSID = ssid;
        this.fStartTime = startTime;
        this.fLatestTime = startTime;
        this.fCurrentIntervals = new TreeSet<ITmfStateInterval>(Comparator.comparing(ITmfStateInterval::getEndTime).thenComparing(ITmfStateInterval::getAttribute));
        fRangeCondition = null;
        fTimeCondition = null;
        fIs2DQuery = false;
    }

    public String getSSID() {
        return this.fSSID;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fLatestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, Object value) throws TimeRangeException {
        if (stateStartTime > stateEndTime || stateStartTime < this.fStartTime) {
            throw new TimeRangeException("Invalid timestamp caused a TimeRangeException: " + this.fSSID + " Interval Start:" + stateStartTime + ", Interval End:" + stateEndTime + ", Backend Start:" + this.fStartTime);
        }
        TmfStateInterval interval = new TmfStateInterval(stateStartTime, stateEndTime, quark, value);
        NavigableSet<ITmfStateInterval> navigableSet = this.fCurrentIntervals;
        synchronized (navigableSet) {
            if (fRangeCondition != null && fTimeCondition != null && fRangeCondition.test(interval.getAttribute()) && fTimeCondition.intersects(interval.getStartTime(), interval.getEndTime()) || !fIs2DQuery) {
                this.fCurrentIntervals.add((ITmfStateInterval)interval);
            }
        }
        if (stateEndTime > this.fLatestTime) {
            this.fLatestTime = stateEndTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery(List<ITmfStateInterval> currentStateInfo, long t) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException("Invalid timestamp caused a TimeRangeException: " + this.fSSID + " Time:" + t + ", Start:" + this.fStartTime + ", End:" + this.fLatestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.fCurrentIntervals;
        synchronized (navigableSet) {
            Iterator<ITmfStateInterval> iter = PartialInMemoryBackend.searchforEndTime(this.fCurrentIntervals, 0, t).iterator();
            int modCount = 0;
            while (iter.hasNext() && modCount < currentStateInfo.size()) {
                ITmfStateInterval entry = iter.next();
                long entryStartTime = entry.getStartTime();
                if (entryStartTime > t) continue;
                currentStateInfo.set(entry.getAttribute(), entry);
                ++modCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException {
        if (!this.checkValidTime(t)) {
            throw new TimeRangeException("Invalid timestamp caused a TimeRangeException: " + this.fSSID + " Time:" + t + ", Start:" + this.fStartTime + ", End:" + this.fLatestTime);
        }
        NavigableSet<ITmfStateInterval> navigableSet = this.fCurrentIntervals;
        synchronized (navigableSet) {
            Iterable<ITmfStateInterval> iter = PartialInMemoryBackend.searchforEndTime(this.fCurrentIntervals, attributeQuark, t);
            for (ITmfStateInterval entry : iter) {
                boolean attributeMatches = entry.getAttribute() == attributeQuark;
                long entryStartTime = entry.getStartTime();
                if (!attributeMatches || entryStartTime > t) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean checkValidTime(long t) {
        return t >= this.fStartTime && t <= this.fLatestTime;
    }

    public void finishedBuilding(long endTime) throws TimeRangeException {
    }

    public FileInputStream supplyAttributeTreeReader() {
        return null;
    }

    public File supplyAttributeTreeWriterFile() {
        return null;
    }

    public long supplyAttributeTreeWriterFilePosition() {
        return -1L;
    }

    public void removeFiles() {
    }

    public void dispose() {
    }

    private static Iterable<@NonNull ITmfStateInterval> searchforEndTime(NavigableSet<@NonNull ITmfStateInterval> tree, int quark, long time) {
        TmfStateInterval dummyInterval = new TmfStateInterval(-1L, time, quark, null);
        return tree.tailSet((ITmfStateInterval)dummyInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarks, TimeRangeCondition times) throws TimeRangeException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "InMemoryBackend:query2D", new Object[]{"ssid", this.getSSID(), "quarks", quarks, "times", times});){
            NavigableSet<ITmfStateInterval> navigableSet = this.fCurrentIntervals;
            synchronized (navigableSet) {
                return Iterables.filter(PartialInMemoryBackend.searchforEndTime(this.fCurrentIntervals, quarks.min(), times.min()), interval -> quarks.test(interval.getAttribute()) && times.intersects(interval.getStartTime(), interval.getEndTime()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateRangeCondition(IntegerRangeCondition range) {
        fRangeCondition = range;
    }

    public void updateTimeCondition(TimeRangeCondition timeConditionrange) {
        fTimeCondition = timeConditionrange;
    }

    public void updateQueryType(boolean type) {
        fIs2DQuery = type;
    }
}

