/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.tree;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfTreeCompositeDataProvider<M extends ITmfTreeDataModel, P extends ITmfTreeDataProvider<M>>
implements ITmfTreeDataProvider<M>,
IOutputAnnotationProvider {
    private final CopyOnWriteArrayList<P> fProviders = new CopyOnWriteArrayList();
    private final String fId;

    public static @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> create(Collection<ITmfTrace> traces, String id) {
        ArrayList<@NonNull ITmfTreeDataProvider> providers = new ArrayList<ITmfTreeDataProvider>();
        for (ITmfTrace child : traces) {
            ITmfTreeDataProvider provider = DataProviderManager.getInstance().getOrCreateDataProvider(child, id, ITmfTreeDataProvider.class);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeDataProvider)providers.get(0);
        }
        return new TmfTreeCompositeDataProvider(providers, id);
    }

    public TmfTreeCompositeDataProvider(List<P> providers, String id) {
        this.fProviders.addAll(providers);
        this.fId = id;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public TmfModelResponse<TmfTreeModel<M>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        ArrayList<AbstractMap.SimpleEntry<ITmfTreeDataModel, Object>> entries = new ArrayList<AbstractMap.SimpleEntry<ITmfTreeDataModel, Object>>();
        List<ITableColumnDescriptor> columnDescriptor = null;
        @NonNull HashBasedTable scopedEntries = HashBasedTable.create();
        for (ITmfTreeDataProvider dataProvider : this.fProviders) {
            HashMap<Long, AtomicInteger> indexMap = new HashMap<Long, AtomicInteger>();
            TmfModelResponse response = dataProvider.fetchTree(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            TmfTreeModel model = response.getModel();
            if (model != null) {
                Object scope = model.getScope() == null ? dataProvider : model.getScope();
                @NonNull Map row = scopedEntries.row(scope);
                for (ITmfTreeDataModel entry : model.getEntries()) {
                    ITmfTreeDataModel previous = row.putIfAbsent(entry.getId(), entry);
                    if (previous == null) {
                        if (entry.getParentId() == -1L) {
                            entries.add(new AbstractMap.SimpleEntry<ITmfTreeDataModel, Object>(entry, scope));
                            continue;
                        }
                        int index = indexMap.computeIfAbsent(entry.getParentId(), l -> new AtomicInteger()).getAndIncrement();
                        int pos = 0;
                        while (pos < entries.size()) {
                            Map.Entry added = (Map.Entry)entries.get(pos);
                            if (added.getValue().equals(scope) && ((ITmfTreeDataModel)added.getKey()).getParentId() == entry.getParentId()) {
                                if (index == 0) break;
                                --index;
                            }
                            ++pos;
                        }
                        if (pos < entries.size()) {
                            entries.add(pos, new AbstractMap.SimpleEntry<ITmfTreeDataModel, Object>(entry, scope));
                            continue;
                        }
                        entries.add(new AbstractMap.SimpleEntry<ITmfTreeDataModel, Object>(entry, scope));
                        continue;
                    }
                    indexMap.computeIfAbsent(entry.getParentId(), l -> new AtomicInteger()).getAndIncrement();
                }
                if (columnDescriptor == null) {
                    columnDescriptor = model.getColumnDescriptors();
                }
            }
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        TmfTreeModel.Builder treeModelBuilder = new TmfTreeModel.Builder();
        if (columnDescriptor == null) {
            columnDescriptor = Collections.emptyList();
        }
        treeModelBuilder.setColumnDescriptors(columnDescriptor).setEntries(Lists.transform(entries, e -> (ITmfTreeDataModel)e.getKey()));
        if (isComplete) {
            return new TmfModelResponse<TmfTreeModel<M>>(treeModelBuilder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<TmfTreeModel<M>>(treeModelBuilder.build(), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    protected List<P> getProviders() {
        return this.fProviders;
    }

    protected void addProvider(P dataProvider) {
        this.fProviders.add(dataProvider);
    }

    protected void removeProvider(P dataProvider) {
        this.fProviders.remove(dataProvider);
        dataProvider.dispose();
    }

    @Override
    public void dispose() {
        this.fProviders.forEach((Consumer<P>)((Consumer<ITmfTreeDataProvider>)ITmfTreeDataProvider::dispose));
        this.fProviders.clear();
    }

    @Override
    public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        AnnotationCategoriesModel model = new AnnotationCategoriesModel(Collections.emptyList());
        for (ITmfTreeDataProvider dataProvider : this.getProviders()) {
            if (!(dataProvider instanceof IOutputAnnotationProvider)) continue;
            TmfModelResponse<AnnotationCategoriesModel> response = ((IOutputAnnotationProvider)((Object)dataProvider)).fetchAnnotationCategories(fetchParameters, monitor);
            model = AnnotationCategoriesModel.of(model, response.getModel());
        }
        if (model.getAnnotationCategories().isEmpty()) {
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationCategoriesModel>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        boolean isComplete = true;
        AnnotationModel model = new AnnotationModel(Collections.emptyMap());
        for (ITmfTreeDataProvider dataProvider : this.getProviders()) {
            if (!(dataProvider instanceof IOutputAnnotationProvider)) continue;
            TmfModelResponse<AnnotationModel> response = ((IOutputAnnotationProvider)((Object)dataProvider)).fetchAnnotations(fetchParameters, monitor);
            isComplete &= response.getStatus() == ITmfResponse.Status.COMPLETED;
            model = AnnotationModel.of(model, response.getModel());
            if (monitor == null || !monitor.isCanceled()) continue;
            return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (isComplete) {
            return new TmfModelResponse<AnnotationModel>(model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        return new TmfModelResponse<AnnotationModel>(model, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
    }
}

