/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarInputStream;

public class TarFile
implements AutoCloseable {
    private final File file;
    private TarInputStream entryEnumerationStream;
    private TarEntry curEntry;
    private TarInputStream entryStream;
    private InputStream internalEntryStream;

    public TarFile(File file) throws TarException, IOException {
        this.file = file;
        InputStream in = new FileInputStream(file);
        try {
            in = new GZIPInputStream(in);
        }
        catch (IOException e) {
            in.close();
            in = new FileInputStream(file);
        }
        try {
            this.entryEnumerationStream = new TarInputStream(in);
        }
        catch (IOException | TarException ex) {
            in.close();
            throw ex;
        }
        this.curEntry = this.entryEnumerationStream.getNextEntry();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.entryEnumerationStream != null) {
                this.entryEnumerationStream.close();
            }
        }
        finally {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
        }
    }

    public TarFile(String filename) throws TarException, IOException {
        this(new File(filename));
    }

    public Enumeration<TarEntry> entries() {
        return new Enumeration<TarEntry>(){

            @Override
            public boolean hasMoreElements() {
                return TarFile.this.curEntry != null;
            }

            @Override
            public TarEntry nextElement() {
                TarEntry oldEntry = TarFile.this.curEntry;
                try {
                    TarFile.this.curEntry = TarFile.this.entryEnumerationStream.getNextEntry();
                }
                catch (IOException | TarException e) {
                    TarFile.this.curEntry = null;
                }
                return oldEntry;
            }
        };
    }

    public InputStream getInputStream(TarEntry entry) throws TarException, IOException {
        if (this.entryStream == null || !this.entryStream.skipToEntry(entry)) {
            if (this.internalEntryStream != null) {
                this.internalEntryStream.close();
            }
            this.internalEntryStream = new FileInputStream(this.file);
            try {
                this.internalEntryStream = new GZIPInputStream(this.internalEntryStream);
            }
            catch (IOException e) {
                this.internalEntryStream.close();
                this.internalEntryStream = new FileInputStream(this.file);
            }
            this.entryStream = new TarInputStream(this.internalEntryStream, entry){

                @Override
                public void close() {
                }
            };
        }
        return this.entryStream;
    }

    public String getName() {
        return this.file.getPath();
    }
}

