/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.unittest.internal.ui.FailureTraceUIBlock;
import org.eclipse.unittest.internal.ui.Messages;
import org.eclipse.unittest.model.ITestElement;

public class UnitTestCopyAction
extends SelectionListenerAction {
    private final FailureTraceUIBlock fView;
    private final Clipboard fClipboard;
    private ITestElement fTestElement;

    public UnitTestCopyAction(FailureTraceUIBlock view, Clipboard clipboard) {
        super(Messages.CopyTrace_action_label);
        Assert.isNotNull((Object)clipboard);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.unittest.ui.copy_trace_action_context");
        this.fView = view;
        this.fClipboard = clipboard;
    }

    public void run() {
        block7: {
            String trace = this.fView.getTrace();
            String source = null;
            if (trace != null) {
                source = this.convertLineTerminators(trace);
            } else if (this.fTestElement != null) {
                source = this.fTestElement.getTestName();
            }
            if (source == null || source.length() == 0) {
                return;
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(source)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getComposite().getShell(), (String)Messages.CopyTraceAction_problem, (String)Messages.CopyTraceAction_clipboard_busy)) break block7;
                this.run();
            }
        }
    }

    public void handleTestSelected(ITestElement test) {
        this.fTestElement = test;
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException e) {
            return in;
        }
        return stringWriter.toString();
    }
}

