/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservablePatternMatchCollection;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservablePatternMatchSet;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryFilterSemantics;

public class ObservablePatternMatchCollectionBuilder<M extends IPatternMatch> {
    private IQuerySpecification<? extends ViatraQueryMatcher<M>> specification = null;
    private EventFilter<M> filter = null;
    private ViatraQueryEngine queryEngine = null;
    private RuleEngine ruleEngine = null;
    private Comparator<M> comparator = null;
    private Function<M, ?> converter = null;
    private ViatraQueryMatcher<M> matcher = null;

    public static <M extends IPatternMatch> ObservablePatternMatchCollectionBuilder<M> create(IQuerySpecification<? extends ViatraQueryMatcher<M>> specification) {
        ObservablePatternMatchCollectionBuilder<M> builder = new ObservablePatternMatchCollectionBuilder<M>(specification);
        return builder;
    }

    public static <M extends IPatternMatch> ObservablePatternMatchCollectionBuilder<M> create(ViatraQueryMatcher<M> matcher) {
        ObservablePatternMatchCollectionBuilder<M> builder = new ObservablePatternMatchCollectionBuilder<M>(matcher);
        return builder;
    }

    protected ObservablePatternMatchCollectionBuilder(IQuerySpecification<? extends ViatraQueryMatcher<M>> specification) {
        this.specification = specification;
    }

    protected ObservablePatternMatchCollectionBuilder(ViatraQueryMatcher<M> matcher) {
        this.matcher = matcher;
        this.queryEngine = matcher.getEngine();
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(EventFilter<M> filter) {
        this.filter = filter;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(M filter) {
        this.filter = Rules.newSingleMatchFilter(filter);
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setFilter(Collection<M> multifilters, ViatraQueryFilterSemantics semantics) {
        this.filter = Rules.newMultiMatchFilter(multifilters, (ViatraQueryFilterSemantics)semantics);
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setEngine(ViatraQueryEngine engine) {
        this.queryEngine = engine;
        this.ruleEngine = null;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setEngine(RuleEngine engine) {
        this.ruleEngine = engine;
        this.queryEngine = null;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setComparator(Comparator<M> comparator) {
        this.comparator = comparator;
        return this;
    }

    public ObservablePatternMatchCollectionBuilder<M> setConverter(Function<M, ?> converter) {
        this.converter = converter;
        return this;
    }

    public ObservablePatternMatchList<M> buildList() {
        this.checkBuilderConfiguration();
        ObservablePatternMatchList observable = new ObservablePatternMatchList();
        ObservablePatternMatchCollection collection = observable.getInternalCollection();
        this.buildCollection(collection);
        return observable;
    }

    public ObservablePatternMatchSet<M> buildSet() {
        this.checkBuilderConfiguration();
        Preconditions.checkState((this.comparator == null ? 1 : 0) != 0, (String)"Cannot use comparator in set!");
        ObservablePatternMatchSet observable = new ObservablePatternMatchSet();
        ObservablePatternMatchCollection collection = observable.getInternalCollection();
        this.buildCollection(collection);
        return observable;
    }

    private void checkBuilderConfiguration() {
        Preconditions.checkState((this.ruleEngine != null || this.queryEngine != null ? 1 : 0) != 0, (String)"(VIATRA Query or Rule) Engine not set!");
        Preconditions.checkState((this.specification != null || this.matcher != null ? 1 : 0) != 0, (String)"Matcher or QuerySpecification not set!");
    }

    private void buildCollection(ObservablePatternMatchCollection<M> collection) {
        collection.createUpdater(this.converter, this.comparator);
        if (this.specification == null) {
            collection.createRuleSpecification(this.matcher);
        } else {
            collection.createRuleSpecification(this.specification);
        }
        collection.setFilter(this.filter);
        if (this.ruleEngine != null) {
            collection.initialize(this.ruleEngine);
        } else {
            collection.initialize(this.queryEngine);
        }
    }
}

