/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.contentassist;

import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class ClassifierPrefixMatcher
extends PrefixMatcher {
    private final PrefixMatcher delegate;
    private final IQualifiedNameConverter qualifiedNameConverter;

    public ClassifierPrefixMatcher(PrefixMatcher delegate, IQualifiedNameConverter qualifiedNameConverter) {
        this.delegate = delegate;
        this.qualifiedNameConverter = qualifiedNameConverter;
    }

    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        if (this.delegate.isCandidateMatchingPrefix(name, prefix)) {
            return true;
        }
        QualifiedName qualifiedName = this.qualifiedNameConverter.toQualifiedName(name);
        QualifiedName qualifiedPrefix = this.qualifiedNameConverter.toQualifiedName(prefix);
        if (qualifiedName.getSegmentCount() > 1) {
            if (qualifiedPrefix.getSegmentCount() == 1) {
                return this.delegate.isCandidateMatchingPrefix(qualifiedName.getSegment(1), qualifiedPrefix.getFirstSegment());
            }
            if (!this.delegate.isCandidateMatchingPrefix(qualifiedName.getFirstSegment(), qualifiedPrefix.getFirstSegment())) {
                return false;
            }
            return this.delegate.isCandidateMatchingPrefix(qualifiedName.getSegment(1), qualifiedPrefix.getSegment(1));
        }
        return false;
    }
}

