/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.MaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public final class DefaultMaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
extends MaskedTupleMemory<Timestamp> {
    protected IMultiLookup<Tuple, Tuple> signatureToTuples;

    public DefaultMaskedTupleMemory(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner) {
        super(mask, owner);
        this.signatureToTuples = CollectionsFactory.createMultiLookup(Object.class, bucketType, Object.class);
    }

    @Override
    public boolean add(Tuple tuple) {
        Tuple signature = this.mask.transform(tuple);
        return this.add(tuple, signature);
    }

    @Override
    public boolean add(Tuple tuple, Tuple signature) {
        try {
            return this.signatureToTuples.addPair(signature, tuple) == IMultiLookup.ChangeGranularity.KEY;
        }
        catch (IllegalStateException ex) {
            throw this.raiseDuplicateInsertion(tuple);
        }
    }

    @Override
    public boolean remove(Tuple tuple) {
        Tuple signature = this.mask.transform(tuple);
        return this.remove(tuple, signature);
    }

    @Override
    public boolean remove(Tuple tuple, Tuple signature) {
        try {
            return this.signatureToTuples.removePair(signature, tuple) == IMultiLookup.ChangeGranularity.KEY;
        }
        catch (IllegalStateException ex) {
            throw this.raiseDuplicateDeletion(tuple);
        }
    }

    @Override
    public Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple signature) {
        throw new UnsupportedOperationException("Timeless memories do not support timestamp-based lookup!");
    }

    @Override
    public Collection<Tuple> get(ITuple signature) {
        IMemoryView<Tuple> bucket = this.signatureToTuples.lookupUnsafe(signature);
        return bucket == null ? null : bucket.distinctValues();
    }

    @Override
    public void clear() {
        this.signatureToTuples.clear();
    }

    @Override
    public Iterable<Tuple> getSignatures() {
        return this.signatureToTuples.distinctKeys();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.signatureToTuples.distinctValues().iterator();
    }

    @Override
    public int getTotalSize() {
        int i = 0;
        for (Tuple key : this.signatureToTuples.distinctKeys()) {
            i += this.signatureToTuples.lookup(key).size();
        }
        return i;
    }

    @Override
    public int getKeysetSize() {
        return this.signatureToTuples.countKeys();
    }
}

